/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.model.data;

import dev.denwav.hypo.model.ClassDataProvider;
import dev.denwav.hypo.model.data.ClassKind;
import dev.denwav.hypo.model.data.FieldData;
import dev.denwav.hypo.model.data.HypoData;
import dev.denwav.hypo.model.data.MethodData;
import dev.denwav.hypo.model.data.MethodDescriptor;
import dev.denwav.hypo.model.data.Visibility;
import dev.denwav.hypo.model.data.types.JvmType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ClassData
extends HypoData {
    public void setProvider(@NotNull ClassDataProvider var1);

    public void setContextClass(boolean var1);

    public boolean isContextClass();

    public void setRequireFullClasspath(boolean var1);

    public boolean isRequireFullClasspath();

    @NotNull
    public String name();

    @Nullable
    public ClassData outerClass() throws IOException;

    public boolean isStaticInnerClass();

    public boolean isFinal();

    public boolean isSynthetic();

    @Deprecated
    @NotNull
    default public ClassKind kind() {
        EnumSet<ClassKind> kinds = this.kinds();
        block6: for (ClassKind kind : kinds) {
            switch (kind) {
                case CLASS: 
                case ABSTRACT_CLASS: 
                case INTERFACE: {
                    continue block6;
                }
                case ENUM: {
                    return ClassKind.ENUM;
                }
                case ANNOTATION: {
                    return ClassKind.ANNOTATION;
                }
                case RECORD: {
                    return ClassKind.RECORD;
                }
            }
        }
        if (kinds.contains((Object)ClassKind.INTERFACE)) {
            return ClassKind.INTERFACE;
        }
        if (kinds.contains((Object)ClassKind.ABSTRACT_CLASS)) {
            return ClassKind.ABSTRACT_CLASS;
        }
        return ClassKind.CLASS;
    }

    @NotNull
    public EnumSet<ClassKind> kinds();

    default public boolean is(@NotNull ClassKind kind) {
        return this.kinds().contains((Object)kind);
    }

    default public boolean isNot(@NotNull ClassKind kind) {
        return !this.is(kind);
    }

    default public boolean isAny(ClassKind ... kinds) {
        for (ClassKind kind : kinds) {
            if (!this.kinds().contains((Object)kind)) continue;
            return true;
        }
        return false;
    }

    default public boolean isAny(@NotNull EnumSet<ClassKind> kinds) {
        for (ClassKind kind : kinds) {
            if (!this.kinds().contains((Object)kind)) continue;
            return true;
        }
        return false;
    }

    default public boolean isAll(ClassKind ... kinds) {
        return this.kinds().containsAll(Arrays.asList(kinds));
    }

    default public boolean isAll(@NotNull EnumSet<ClassKind> kinds) {
        return this.kinds().containsAll(kinds);
    }

    @NotNull
    public Visibility visibility();

    @Nullable
    public ClassData superClass() throws IOException;

    @NotNull
    public List<ClassData> interfaces() throws IOException;

    public boolean isSealed();

    public @Nullable List<@NotNull ClassData> permittedClasses() throws IOException;

    @ApiStatus.Experimental
    public @Nullable List<@NotNull FieldData> recordComponents();

    @NotNull
    default public @NotNull Stream<@NotNull ClassData> allSuperClasses() throws IOException {
        ClassData superClass = this.superClass();
        List<ClassData> superInterfaces = this.interfaces();
        if (superClass == null && superInterfaces.isEmpty()) {
            return Stream.empty();
        }
        if (superClass == null) {
            return superInterfaces.stream();
        }
        if (superInterfaces.isEmpty()) {
            return Stream.of(superClass);
        }
        ClassData[] res = new ClassData[superInterfaces.size() + 1];
        res[0] = superClass;
        int index = 1;
        for (ClassData superInterface : superInterfaces) {
            res[index++] = superInterface;
        }
        return Arrays.stream(res);
    }

    default public <X extends Throwable> void forEachSuperClass(@NotNull  @NotNull HypoModelUtil.ThrowingConsumer<@NotNull ClassData, X> consumer) throws IOException, X {
        ClassData superClass = this.superClass();
        if (superClass != null) {
            consumer.acceptThrowing(superClass);
        }
        for (ClassData superInter : this.interfaces()) {
            consumer.acceptThrowing(superInter);
        }
    }

    @NotNull
    public List<FieldData> fields();

    @NotNull
    public List<MethodData> methods();

    default public boolean doesExtend(@NotNull ClassData that) {
        if (this.equals(that)) {
            return true;
        }
        try {
            ClassData superClass = this.superClass();
            if (superClass != null) {
                return superClass.doesExtend(that);
            }
        }
        catch (IOException ignored) {
            return false;
        }
        return false;
    }

    default public boolean doesImplement(@NotNull ClassData that) {
        if (this.equals(that)) {
            return true;
        }
        try {
            for (ClassData iface : this.interfaces()) {
                if (iface == null) continue;
                return iface.doesImplement(that);
            }
        }
        catch (IOException ignored) {
            return false;
        }
        return false;
    }

    default public boolean doesExtendOrImplement(@NotNull ClassData that) {
        if (this.equals(that)) {
            return true;
        }
        try {
            return this.allSuperClasses().anyMatch(s2 -> s2.doesExtendOrImplement(that));
        }
        catch (IOException ignored) {
            return false;
        }
    }

    @NotNull
    default public @NotNull List<@NotNull FieldData> fields(@NotNull String name) {
        ArrayList<FieldData> result = null;
        FieldData singleResult = null;
        for (FieldData field : this.fields()) {
            if (!field.name().equals(name)) continue;
            if (singleResult == null) {
                singleResult = field;
                continue;
            }
            if (result == null) {
                result = new ArrayList<FieldData>();
                result.add(singleResult);
                result.add(field);
                continue;
            }
            result.add(field);
        }
        if (result != null) {
            return Collections.unmodifiableList(result);
        }
        if (singleResult != null) {
            return Collections.singletonList(singleResult);
        }
        return Collections.emptyList();
    }

    @Nullable
    default public FieldData field(@NotNull String name, @NotNull JvmType type) {
        for (FieldData field : this.fields()) {
            if (!field.name().equals(name) || !field.fieldType().equals(type)) continue;
            return field;
        }
        return null;
    }

    @NotNull
    default public @NotNull List<@NotNull MethodData> methods(@NotNull String name) {
        ArrayList<MethodData> result = null;
        MethodData singleResult = null;
        for (MethodData method : this.methods()) {
            if (!method.name().equals(name)) continue;
            if (singleResult == null) {
                singleResult = method;
                continue;
            }
            if (result == null) {
                result = new ArrayList<MethodData>();
                result.add(singleResult);
                result.add(method);
                continue;
            }
            result.add(method);
        }
        if (result != null) {
            return Collections.unmodifiableList(result);
        }
        if (singleResult != null) {
            return Collections.singletonList(singleResult);
        }
        return Collections.emptyList();
    }

    @Nullable
    default public MethodData method(@NotNull String name, @NotNull MethodDescriptor descriptor) {
        for (MethodData method : this.methods()) {
            if (!method.name().equals(name) || !method.descriptor().equals(descriptor)) continue;
            return method;
        }
        return null;
    }

    @NotNull
    public @NotNull Set<@NotNull ClassData> childClasses();

    @NotNull
    public @NotNull Set<@NotNull ClassData> innerClasses();
}

