/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.model;

import dev.denwav.hypo.model.ClassDataDecorator;
import dev.denwav.hypo.model.ClassProviderRoot;
import dev.denwav.hypo.model.HypoModelUtil;
import dev.denwav.hypo.model.data.ClassData;
import dev.denwav.hypo.model.data.types.ClassType;
import dev.denwav.hypo.model.data.types.JvmType;
import java.io.IOException;
import java.util.Collection;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ClassDataProvider
extends AutoCloseable {
    public void setDecorator(@NotNull ClassDataDecorator var1);

    public void setContextClassProvider(boolean var1);

    public boolean isContextClassProvider();

    public void setRequireFullClasspath(boolean var1);

    public boolean isRequireFullClasspath();

    @Contract(value="null -> null")
    @Nullable
    public ClassData findClass(@Nullable String var1) throws IOException;

    @Contract(value="null -> null")
    @Nullable
    default public ClassData findClass(@Nullable JvmType type) throws IOException {
        if (!(type instanceof ClassType)) {
            return null;
        }
        return this.findClass(type.asInternalName());
    }

    @NotNull
    default public Iterable<ClassData> allClasses() {
        return () -> {
            try {
                return this.stream().iterator();
            }
            catch (IOException e) {
                throw HypoModelUtil.rethrow(e);
            }
        };
    }

    @NotNull
    public Stream<ClassData> stream() throws IOException;

    @NotNull
    public Collection<ClassProviderRoot> roots();

    @Override
    public void close() throws IOException;
}

