/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.mappings.changes;

import dev.denwav.hypo.mappings.ClassMappingsChange;
import dev.denwav.hypo.mappings.LorenzUtil;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.model.ClassMapping;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class RemoveClassMappingChange
implements ClassMappingsChange {
    @NotNull
    private final String targetClass;

    private RemoveClassMappingChange(@NotNull String targetClass) {
        this.targetClass = targetClass;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static RemoveClassMappingChange of(@NotNull String targetClass) {
        return new RemoveClassMappingChange(targetClass);
    }

    @Override
    @NotNull
    public String targetClass() {
        return this.targetClass;
    }

    @Override
    public void applyChange(@NotNull MappingSet input) {
        ClassMapping<?, ?> mapping = LorenzUtil.getClassMapping(input, this.targetClass);
        if (mapping == null) {
            return;
        }
        LorenzUtil.removeClassMapping(mapping);
    }
}

