/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.mappings.changes;

import com.google.errorprone.annotations.Immutable;
import dev.denwav.hypo.mappings.LorenzUtil;
import dev.denwav.hypo.model.data.FieldData;
import dev.denwav.hypo.model.data.MethodData;
import java.util.Objects;
import org.cadixdev.bombe.type.FieldType;
import org.cadixdev.lorenz.model.ClassMapping;
import org.cadixdev.lorenz.model.FieldMapping;
import org.cadixdev.lorenz.model.MethodMapping;
import org.cadixdev.lorenz.model.MethodParameterMapping;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class MemberReference {
    @NotNull
    private final String className;
    @NotNull
    private final String memberName;
    @Nullable
    private final String memberDesc;
    private final int index;

    public MemberReference(@NotNull String className, @NotNull String memberName, @Nullable String memberDesc) {
        this.className = className;
        this.memberName = memberName;
        this.memberDesc = memberDesc;
        this.index = -1;
    }

    public MemberReference(@NotNull String className, @NotNull String memberName, @NotNull String memberDesc, int index) {
        this.className = className;
        this.memberName = memberName;
        this.memberDesc = memberDesc;
        this.index = index;
    }

    @NotNull
    public static MemberReference of(@NotNull MethodData method) {
        return new MemberReference(method.parentClass().name(), method.name(), method.descriptorText());
    }

    @NotNull
    public static MemberReference of(@NotNull FieldData field) {
        return new MemberReference(field.parentClass().name(), field.name(), field.fieldType().asInternalName());
    }

    @NotNull
    public static MemberReference of(@NotNull MethodData method, int index) {
        return new MemberReference(method.parentClass().name(), method.name(), method.descriptorText(), index);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static MemberReference of(@NotNull MethodMapping mapping) {
        return new MemberReference(((ClassMapping)mapping.getParent()).getFullObfuscatedName(), mapping.getObfuscatedName(), mapping.getObfuscatedDescriptor());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static MemberReference of(@NotNull FieldMapping mapping) {
        FieldType type = LorenzUtil.getType(mapping);
        return new MemberReference(((ClassMapping)mapping.getParent()).getFullObfuscatedName(), mapping.getObfuscatedName(), type == null ? null : type.toString());
    }

    @NotNull
    public static MemberReference of(@NotNull MethodParameterMapping mapping) {
        MethodMapping method = (MethodMapping)mapping.getParent();
        return new MemberReference(((ClassMapping)method.getParent()).getFullObfuscatedName(), method.getObfuscatedName(), method.getObfuscatedDescriptor(), mapping.getIndex());
    }

    @NotNull
    public String className() {
        return this.className;
    }

    @NotNull
    public String name() {
        return this.memberName;
    }

    @Nullable
    public String desc() {
        return this.memberDesc;
    }

    public int index() {
        return this.index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemberReference that = (MemberReference)o;
        return this.className.equals(that.className) && this.memberName.equals(that.memberName) && Objects.equals(this.memberDesc, that.memberDesc) && this.index == that.index;
    }

    public int hashCode() {
        return Objects.hash(this.className, this.memberName, this.memberDesc, this.index);
    }

    public String toString() {
        if (this.memberDesc != null) {
            if (this.index != -1) {
                return this.className + "#" + this.memberName + this.memberDesc + "##" + this.index;
            }
            return this.className + "#" + this.memberName + " " + this.memberDesc;
        }
        return this.className + "#" + this.memberName;
    }
}

