/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.mappings.changes;

import dev.denwav.hypo.mappings.MergeResult;
import dev.denwav.hypo.mappings.MergeableMappingsChange;
import dev.denwav.hypo.mappings.changes.AbstractMappingsChange;
import dev.denwav.hypo.mappings.changes.MemberReference;
import org.cadixdev.bombe.type.FieldType;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.model.ClassMapping;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class AddNewMappingChange
extends AbstractMappingsChange
implements MergeableMappingsChange<AddNewMappingChange> {
    @NotNull
    private final String newName;

    private AddNewMappingChange(@NotNull MemberReference target, @NotNull String newName) {
        super(target);
        this.newName = newName;
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static AddNewMappingChange of(@NotNull MemberReference target, @NotNull String newName) {
        return new AddNewMappingChange(target, newName);
    }

    @Override
    public void applyChange(@NotNull MappingSet input, @NotNull MemberReference target) {
        ClassMapping<?, ?> map = input.getOrCreateClassMapping(target.className());
        String desc = target.desc();
        if (desc != null && desc.indexOf(40) != -1) {
            map.getOrCreateMethodMapping(target.name(), desc).setDeobfuscatedName(this.newName);
        } else if (desc == null) {
            map.getOrCreateFieldMapping(target.name()).setDeobfuscatedName(this.newName);
        } else {
            map.getOrCreateFieldMapping(target.name(), FieldType.of(desc)).setDeobfuscatedName(this.newName);
        }
    }

    @Override
    @NotNull
    public MergeResult<AddNewMappingChange> mergeWith(@NotNull AddNewMappingChange that) {
        if (this.newName.equals(that.newName)) {
            return MergeResult.success(this);
        }
        return MergeResult.failure("Cannot merge add mapping changes with different names");
    }

    public String toString() {
        return "Add mapping '" + this.newName + "' to " + this.target();
    }
}

