/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.hydrate;

import dev.denwav.hypo.core.HypoContext;
import dev.denwav.hypo.hydrate.ClassDataHydrator;
import dev.denwav.hypo.hydrate.HydrationManager;
import dev.denwav.hypo.hydrate.HydrationProvider;
import dev.denwav.hypo.model.HypoModelUtil;
import dev.denwav.hypo.model.data.ClassData;
import dev.denwav.hypo.model.data.FieldData;
import dev.denwav.hypo.model.data.HypoData;
import dev.denwav.hypo.model.data.HypoKey;
import dev.denwav.hypo.model.data.MethodData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;

public class DefaultHydrationManager
implements HydrationManager {
    @NotNull
    private final ClassDataHydrator baseHydrator;
    @NotNull
    private final List<HydrationProvider<?>> classProviders = new ArrayList();
    @NotNull
    private final List<HydrationProvider<?>> methodProviders = new ArrayList();
    @NotNull
    private final List<HydrationProvider<?>> fieldProviders = new ArrayList();

    public DefaultHydrationManager() {
        this(ClassDataHydrator.createDefault());
    }

    public DefaultHydrationManager(@NotNull ClassDataHydrator baseHydrator) {
        this.baseHydrator = baseHydrator;
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public HydrationManager register(@NotNull HydrationProvider<? extends HypoData> provider) {
        Class<? extends HypoData> targetClass = provider.target();
        if (ClassData.class.isAssignableFrom(targetClass)) {
            this.classProviders.add(provider);
        } else if (MethodData.class.isAssignableFrom(targetClass)) {
            this.methodProviders.add(provider);
        } else if (FieldData.class.isAssignableFrom(targetClass)) {
            this.fieldProviders.add(provider);
        } else {
            throw new IllegalArgumentException("Given HydrationProvider (" + provider + ") targets an invalid type: " + targetClass);
        }
        return this;
    }

    @Override
    public void hydrate(@NotNull HypoContext context) throws IOException {
        try {
            HashSet<HydrationProvider<?>> stage;
            this.baseHydrator.hydrate(context);
            Graph<HydrationProvider<?>, DefaultEdge> providersGraph = this.createProviderGraph();
            while (!(stage = this.getNextStage(providersGraph)).isEmpty()) {
                this.executeProviderStage(context, stage);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            HypoModelUtil.rethrow(e);
        }
    }

    private void executeProviderStage(@NotNull HypoContext context, @NotNull HashSet<HydrationProvider<?>> stage) throws ExecutionException, InterruptedException {
        ExecutorService executor = context.getExecutor();
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        for (ClassData classData : context.getProvider().allClasses()) {
            futures.add(executor.submit(() -> {
                if (DefaultHydrationManager.containsAny(stage, this.classProviders)) {
                    for (HydrationProvider<?> provider : this.classProviders) {
                        if (!stage.contains(provider) || !provider.target().isInstance(classData)) continue;
                        provider.hydrate((HypoData)HypoModelUtil.cast(classData), context);
                    }
                }
                if (DefaultHydrationManager.containsAny(stage, this.methodProviders)) {
                    for (MethodData method : classData.methods()) {
                        for (HydrationProvider<?> provider : this.methodProviders) {
                            if (!stage.contains(provider) || !provider.target().isInstance(method)) continue;
                            provider.hydrate((HypoData)HypoModelUtil.cast(method), context);
                        }
                    }
                }
                if (DefaultHydrationManager.containsAny(stage, this.fieldProviders)) {
                    for (FieldData field : classData.fields()) {
                        for (HydrationProvider<?> provider : this.fieldProviders) {
                            if (!stage.contains(provider) || !provider.target().isInstance(field)) continue;
                            provider.hydrate((HypoData)HypoModelUtil.cast(field), context);
                        }
                    }
                }
                return null;
            }));
        }
        for (Future future : futures) {
            future.get();
        }
    }

    private static <T> boolean containsAny(Set<T> set, List<T> list) {
        for (T t2 : list) {
            if (!set.contains(t2)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private Graph<HydrationProvider<?>, DefaultEdge> createProviderGraph() {
        ArrayList allProviders = new ArrayList(this.classProviders.size() + this.methodProviders.size() + this.fieldProviders.size());
        allProviders.addAll(this.classProviders);
        allProviders.addAll(this.methodProviders);
        allProviders.addAll(this.fieldProviders);
        DefaultDirectedGraph g2 = new DefaultDirectedGraph(DefaultEdge.class);
        for (HydrationProvider hydrationProvider : allProviders) {
            g2.addVertex(hydrationProvider);
            for (HypoKey<?> dependentKey : hydrationProvider.dependsOn()) {
                for (HydrationProvider hydrationProvider2 : allProviders) {
                    for (HypoKey<?> providedKey : hydrationProvider2.provides()) {
                        if (dependentKey != providedKey) continue;
                        g2.addVertex(hydrationProvider2);
                        g2.addEdge(hydrationProvider2, hydrationProvider);
                    }
                }
            }
        }
        return g2;
    }

    @NotNull
    private HashSet<HydrationProvider<?>> getNextStage(@NotNull Graph<HydrationProvider<?>, ?> graph) {
        LinkedHashSet stage = new LinkedHashSet();
        for (HydrationProvider<?> provider : graph.vertexSet()) {
            if (graph.inDegreeOf(provider) != 0) continue;
            stage.add(provider);
        }
        graph.removeAllVertices(stage);
        return stage;
    }
}

