/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.hydrate;

import dev.denwav.hypo.core.HypoContext;
import dev.denwav.hypo.core.HypoException;
import dev.denwav.hypo.hydrate.ClassDataHydrator;
import dev.denwav.hypo.model.HypoModelUtil;
import dev.denwav.hypo.model.data.ClassData;
import dev.denwav.hypo.model.data.MethodData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.traverse.TopologicalOrderIterator;

public class DefaultClassDataHydrator
implements ClassDataHydrator {
    @Override
    public void hydrate(@NotNull HypoContext context) throws IOException {
        ExecutorService executor = context.getExecutor();
        DefaultDirectedGraph<ClassData, DefaultEdge> g2 = new DefaultDirectedGraph<ClassData, DefaultEdge>(DefaultEdge.class);
        for (ClassData classData : context.getProvider().allClasses()) {
            ClassData classData2;
            g2.addVertex(classData);
            ClassData superClassData = classData.superClass();
            if (superClassData != null) {
                DefaultClassDataHydrator.addEdge(superClassData, classData, g2);
                superClassData.childClasses().add(classData);
            }
            if ((classData2 = classData.outerClass()) != null) {
                DefaultClassDataHydrator.addEdge(classData2, classData, g2);
                classData2.innerClasses().add(classData);
            }
            for (ClassData interData : classData.interfaces()) {
                DefaultClassDataHydrator.addEdge(interData, classData, g2);
                interData.childClasses().add(classData);
            }
        }
        TopologicalOrderIterator iter = new TopologicalOrderIterator(g2);
        iter.setReuseEvents(true);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        while (iter.hasNext()) {
            ClassData nextClass = (ClassData)iter.next();
            futures.add(executor.submit(() -> {
                try {
                    DefaultClassDataHydrator.fillMethods(nextClass);
                }
                catch (Exception e) {
                    throw new HypoException("Unhandled error while hydrating " + nextClass.name(), e);
                }
                return null;
            }));
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                HypoModelUtil.rethrow(e);
            }
        }
    }

    private static <T> void addEdge(@Nullable T source, @NotNull T target, @NotNull Graph<T, ?> g2) {
        if (source == null) {
            return;
        }
        g2.addVertex(source);
        g2.addEdge(source, target);
    }

    private static void fillMethods(@NotNull ClassData classData) throws IOException {
        for (MethodData method : classData.methods()) {
            if (method.isConstructor()) continue;
            classData.forEachSuperClass(p -> DefaultClassDataHydrator.checkMethods(method, p));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkMethods(@NotNull MethodData baseMethod, @Nullable ClassData parentClass) throws IOException {
        if (parentClass == null) {
            return;
        }
        parentClass.forEachSuperClass(p -> DefaultClassDataHydrator.checkMethods(baseMethod, p));
        for (MethodData method : parentClass.methods()) {
            Set<MethodData> chi;
            if (method.isConstructor() || baseMethod.equals(method) || !baseMethod.overrides(method)) continue;
            baseMethod.setSuperMethod(method);
            Set<MethodData> set = chi = method.childMethods();
            synchronized (set) {
                chi.add(baseMethod);
            }
        }
    }
}

