/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.asm.hydrate;

import dev.denwav.hypo.asm.AsmClassData;
import dev.denwav.hypo.asm.AsmMethodData;
import dev.denwav.hypo.asm.HypoAsmUtil;
import dev.denwav.hypo.core.HypoContext;
import dev.denwav.hypo.hydrate.HydrationProvider;
import dev.denwav.hypo.hydrate.generic.HypoHydration;
import dev.denwav.hypo.hydrate.generic.LambdaClosure;
import dev.denwav.hypo.hydrate.generic.LocalClassClosure;
import dev.denwav.hypo.model.HypoModelUtil;
import dev.denwav.hypo.model.data.ClassData;
import dev.denwav.hypo.model.data.FieldData;
import dev.denwav.hypo.model.data.HypoKey;
import dev.denwav.hypo.model.data.MethodData;
import dev.denwav.hypo.model.data.types.JvmType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class LocalClassHydrator
implements HydrationProvider<AsmMethodData> {
    private LocalClassHydrator() {
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static LocalClassHydrator create() {
        return new LocalClassHydrator();
    }

    @Override
    public List<HypoKey<?>> provides() {
        return HypoModelUtil.immutableListOf(HypoHydration.LOCAL_CLASSES);
    }

    @Override
    public List<HypoKey<?>> dependsOn() {
        return HypoModelUtil.immutableListOf(HypoHydration.LAMBDA_CALLS);
    }

    @Override
    @NotNull
    public Class<? extends AsmMethodData> target() {
        return AsmMethodData.class;
    }

    @Override
    public void hydrate(@NotNull AsmMethodData data, @NotNull HypoContext context) throws IOException {
        @Nullable ArrayList<AsmClassData> nestedClasses = null;
        Set<@NotNull ClassData> innerClasses = data.parentClass().innerClasses();
        for (ClassData innerClass : innerClasses) {
            AsmClassData asmInnerclass = (AsmClassData)innerClass;
            ClassNode innerNode = asmInnerclass.getNode();
            if (!data.name().equals(innerNode.outerMethod) || !data.descriptorText().equals(innerNode.outerMethodDesc)) continue;
            if (nestedClasses == null) {
                nestedClasses = new ArrayList<AsmClassData>();
            }
            nestedClasses.add(asmInnerclass);
        }
        if (nestedClasses == null) {
            return;
        }
        this.findNewCalls(data, nestedClasses);
        if (nestedClasses.isEmpty()) {
            return;
        }
        for (AsmClassData nestedClass : nestedClasses) {
            LocalClassHydrator.setCall(data, nestedClass, HypoAsmUtil.EMPTY_INT_ARRAY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setCall(MethodData data, ClassData nestedClass, int[] params) {
        List targetClosures;
        List closures;
        LocalClassClosure call = new LocalClassClosure(data, nestedClass, params);
        List list = closures = data.compute(HypoHydration.LOCAL_CLASSES, ArrayList::new);
        synchronized (list) {
            closures.add(call);
        }
        List list2 = targetClosures = nestedClass.compute(HypoHydration.LOCAL_CLASSES, ArrayList::new);
        synchronized (list2) {
            targetClosures.add(call);
        }
    }

    private void findNewCalls(MethodData method, ArrayList<AsmClassData> nestedClasses) {
        MethodNode node = ((AsmMethodData)method).getNode();
        for (AbstractInsnNode insn : node.instructions) {
            if (insn.getOpcode() != 183) continue;
            MethodInsnNode methodInsn = (MethodInsnNode)insn;
            if (!methodInsn.name.equals("<init>")) continue;
            Iterator<AsmClassData> it = nestedClasses.iterator();
            while (it.hasNext()) {
                AsmClassData nestedClass = it.next();
                if (!nestedClass.name().equals(methodInsn.owner)) continue;
                int @Nullable [] closureIndices = this.handleNestedConst(methodInsn, nestedClass);
                LocalClassHydrator.setCall(method, nestedClass, closureIndices != null ? closureIndices : HypoAsmUtil.EMPTY_INT_ARRAY);
                it.remove();
            }
        }
        if (nestedClasses.isEmpty()) {
            return;
        }
        List<LambdaClosure> lambdaCalls = method.get(HypoHydration.LAMBDA_CALLS);
        if (lambdaCalls == null) {
            return;
        }
        for (LambdaClosure lambdaCall : lambdaCalls) {
            if (nestedClasses.isEmpty()) {
                return;
            }
            if (!lambdaCall.getContainingMethod().equals(method)) continue;
            this.findNewCalls(lambdaCall.getLambda(), nestedClasses);
        }
    }

    private int @Nullable [] handleNestedConst(MethodInsnNode insn, AsmClassData nestedClass) {
        ArrayList<JvmType> capturedVariables = new ArrayList<JvmType>();
        for (FieldData field : nestedClass.fields()) {
            if (!field.isSynthetic() || field.name().startsWith("this") || !field.name().startsWith("val$")) continue;
            capturedVariables.add(field.fieldType());
        }
        int[] closureIndices = new int[capturedVariables.size()];
        AbstractInsnNode prevInsn = insn;
        for (int i = closureIndices.length - 1; i >= 0 && (prevInsn = prevInsn.getPrevious()).getType() == 2; --i) {
            VarInsnNode var = (VarInsnNode)prevInsn;
            closureIndices[i] = var.var;
            if (i != 0) continue;
            return closureIndices;
        }
        return null;
    }
}

