/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.asm.hydrate;

import dev.denwav.hypo.asm.AsmMethodData;
import dev.denwav.hypo.asm.HypoAsmUtil;
import dev.denwav.hypo.core.HypoContext;
import dev.denwav.hypo.hydrate.HydrationProvider;
import dev.denwav.hypo.hydrate.generic.HypoHydration;
import dev.denwav.hypo.hydrate.generic.LambdaClosure;
import dev.denwav.hypo.model.HypoModelUtil;
import dev.denwav.hypo.model.data.ClassData;
import dev.denwav.hypo.model.data.HypoKey;
import dev.denwav.hypo.model.data.MethodData;
import dev.denwav.hypo.model.data.MethodDescriptor;
import dev.denwav.hypo.model.data.types.JvmType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class LambdaCallHydrator
implements HydrationProvider<AsmMethodData> {
    private static final Handle lambdaMetafactoryHandle = new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false);

    private LambdaCallHydrator() {
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static LambdaCallHydrator create() {
        return new LambdaCallHydrator();
    }

    @Override
    public List<HypoKey<?>> provides() {
        return HypoModelUtil.immutableListOf(HypoHydration.LAMBDA_CALLS);
    }

    @Override
    @NotNull
    public Class<? extends AsmMethodData> target() {
        return AsmMethodData.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hydrate(@NotNull AsmMethodData data, @NotNull HypoContext context) throws IOException {
        MethodNode node = data.getNode();
        block9: for (AbstractInsnNode insn : node.instructions) {
            List interfaceMethodLambdas;
            List targetCalls;
            List methodClosures;
            Object bsmArgHandle;
            if (insn.getOpcode() != 186) continue;
            InvokeDynamicInsnNode dyn = (InvokeDynamicInsnNode)insn;
            if (!lambdaMetafactoryHandle.equals(dyn.bsm) || dyn.bsmArgs.length != 3 || !((bsmArgHandle = dyn.bsmArgs[1]) instanceof Handle)) continue;
            Handle handle = (Handle)bsmArgHandle;
            Object bsmDesc = dyn.bsmArgs[0];
            if (!(bsmDesc instanceof Type)) continue;
            Type interfaceDesc = (Type)bsmDesc;
            ClassData owner = data.parentClass().name().equals(handle.getOwner()) ? data.parentClass() : context.getContextProvider().findClass(handle.getOwner());
            if (owner == null) continue;
            MethodDescriptor desc = MethodDescriptor.parseDescriptor(dyn.desc);
            List<@NotNull JvmType> params = desc.getParams();
            int paramsSize = params.size();
            int[] closureIndices = new int[paramsSize];
            boolean finished = false;
            AbstractInsnNode prevInsn = insn;
            for (int i = paramsSize - 1; i >= 0 && (prevInsn = prevInsn.getPrevious()).getType() == 2; --i) {
                VarInsnNode var = (VarInsnNode)prevInsn;
                closureIndices[i] = var.var;
                if (i != 0) continue;
                finished = true;
            }
            MethodData targetMethod = owner.method(handle.getName(), MethodDescriptor.parseDescriptor(handle.getDesc()));
            if (targetMethod == null) continue;
            MethodData interfaceMethod = null;
            ClassData interfaceType = context.getContextProvider().findClass(desc.getReturnType());
            if (interfaceType != null) {
                interfaceMethod = interfaceType.method(dyn.name, HypoAsmUtil.toDescriptor(interfaceDesc));
            }
            LambdaClosure call = new LambdaClosure(data, interfaceMethod, targetMethod, finished ? closureIndices : HypoAsmUtil.EMPTY_INT_ARRAY);
            List list = methodClosures = data.compute(HypoHydration.LAMBDA_CALLS, ArrayList::new);
            synchronized (list) {
                methodClosures.add(call);
            }
            List list2 = targetCalls = targetMethod.compute(HypoHydration.LAMBDA_CALLS, ArrayList::new);
            synchronized (list2) {
                targetCalls.add(call);
            }
            if (interfaceMethod == null) continue;
            List list3 = interfaceMethodLambdas = interfaceMethod.compute(HypoHydration.LAMBDA_CALLS, ArrayList::new);
            synchronized (list3) {
                for (LambdaClosure lambdaClosure : interfaceMethodLambdas) {
                    if (!lambdaClosure.getLambda().equals(targetMethod)) continue;
                    continue block9;
                }
                interfaceMethodLambdas.add(call);
            }
        }
    }
}

