/*
 * Decompiled with CFR 0.152.
 */
package dev.denwav.hypo.asm;

import dev.denwav.hypo.asm.AsmConstructorData;
import dev.denwav.hypo.asm.AsmFieldData;
import dev.denwav.hypo.asm.AsmMethodData;
import dev.denwav.hypo.asm.HypoAsmUtil;
import dev.denwav.hypo.core.HypoException;
import dev.denwav.hypo.model.ClassDataProvider;
import dev.denwav.hypo.model.HypoModelUtil;
import dev.denwav.hypo.model.data.ClassData;
import dev.denwav.hypo.model.data.ClassKind;
import dev.denwav.hypo.model.data.FieldData;
import dev.denwav.hypo.model.data.LazyClassData;
import dev.denwav.hypo.model.data.MethodData;
import dev.denwav.hypo.model.data.MethodDescriptor;
import dev.denwav.hypo.model.data.Visibility;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.RecordComponentNode;

public class AsmClassData
extends LazyClassData {
    @NotNull
    private final ClassNode node;

    public AsmClassData(@NotNull ClassNode node) {
        this.node = node;
    }

    @NotNull
    public ClassNode getNode() {
        return this.node;
    }

    @Override
    @NotNull
    public String computeName() {
        return this.name();
    }

    @Override
    @NotNull
    public String name() {
        return this.node.name;
    }

    @Override
    @Nullable
    public ClassData computeOuterClass() throws IOException {
        if (this.node.outerClass != null) {
            return this.prov().findClass(this.node.outerClass);
        }
        String thisName = this.name();
        for (int i = 0; i < this.node.innerClasses.size(); ++i) {
            InnerClassNode innerClassNode = this.node.innerClasses.get(i);
            if (!Objects.equals(thisName, innerClassNode.name) || innerClassNode.outerName == null) continue;
            return this.prov().findClass(innerClassNode.outerName);
        }
        return null;
    }

    @Override
    public boolean computeStaticInnerClass() {
        if (this.node.outerClass != null) {
            if ((this.node.access & 0x14008) != 0) {
                return true;
            }
            if (this.node.outerMethod != null) {
                MethodData outerMethod;
                ClassData outerClass;
                try {
                    outerClass = this.outerClass();
                }
                catch (IOException e) {
                    throw HypoModelUtil.rethrow(e);
                }
                if (outerClass != null && (outerMethod = outerClass.method(this.node.outerMethod, MethodDescriptor.parseDescriptor(this.node.outerMethodDesc))) != null) {
                    return outerMethod.isStatic();
                }
            }
            return false;
        }
        String thisName = this.name();
        for (int i = 0; i < this.node.innerClasses.size(); ++i) {
            InnerClassNode innerClassNode = this.node.innerClasses.get(i);
            if (!Objects.equals(thisName, innerClassNode.name) || innerClassNode.outerName == null) continue;
            return (innerClassNode.access & 0x14008) != 0;
        }
        return false;
    }

    @Override
    public boolean computeIsFinal() {
        return this.isFinal();
    }

    @Override
    public boolean isFinal() {
        return (this.node.access & 0x10) != 0;
    }

    @Override
    public boolean computeIsSynthetic() {
        return this.isSynthetic();
    }

    @Override
    public boolean isSynthetic() {
        return (this.node.access & 0x1000) != 0;
    }

    @Override
    public boolean computeIsSealed() {
        return this.isSealed();
    }

    @Override
    public boolean isSealed() {
        return this.node.permittedSubclasses != null;
    }

    @Override
    @Nullable
    public List<ClassData> computePermittedClasses() throws IOException {
        List<String> permitted = this.node.permittedSubclasses;
        if (permitted == null) {
            return null;
        }
        ArrayList<ClassData> result = new ArrayList<ClassData>(permitted.size());
        for (String name : permitted) {
            result.add(this.prov().findClass(name));
        }
        return result;
    }

    @Override
    public @Nullable List<@NotNull FieldData> computeRecordComponents() {
        List<RecordComponentNode> components = this.node.recordComponents;
        if (components == null) {
            return null;
        }
        ArrayList<@NotNull FieldData> result = new ArrayList<FieldData>();
        for (RecordComponentNode componentNode : components) {
            FieldData field = this.field(componentNode.name, HypoAsmUtil.toJvmType(Type.getType(componentNode.descriptor)));
            if (field == null) continue;
            result.add(field);
        }
        return result;
    }

    @Override
    @NotNull
    public EnumSet<ClassKind> computeClassKinds() {
        EnumSet<ClassKind> kinds = EnumSet.noneOf(ClassKind.class);
        if ((this.node.access & 0x2000) != 0) {
            kinds.add(ClassKind.ANNOTATION);
        }
        if ((this.node.access & 0x200) != 0) {
            kinds.add(ClassKind.INTERFACE);
        }
        if ((this.node.access & 0x400) != 0) {
            kinds.add(ClassKind.ABSTRACT_CLASS);
        }
        if ((this.node.access & 0x4000) != 0) {
            kinds.add(ClassKind.ENUM);
        }
        if ((this.node.access & 0x10000) != 0) {
            kinds.add(ClassKind.RECORD);
        }
        if (kinds.isEmpty()) {
            kinds.add(ClassKind.CLASS);
        }
        return kinds;
    }

    @Override
    @NotNull
    public EnumSet<ClassKind> kinds() {
        return EnumSet.copyOf(super.kinds());
    }

    @Override
    @NotNull
    public Visibility computeVisibility() {
        return this.visibility();
    }

    @Override
    @NotNull
    public Visibility visibility() {
        return HypoAsmUtil.accessToVisibility(this.node.access);
    }

    @Override
    @Nullable
    public ClassData computeSuperClass() throws IOException {
        String superName = this.node.superName;
        if (superName == null) {
            return null;
        }
        ClassData superClassData = this.prov().findClass(superName);
        if (superClassData == null && this.isRequireFullClasspath()) {
            throw new HypoException("Unable to resolve class data binding for '" + superName + "' which is listed as the super class for '" + this.name() + "'");
        }
        return superClassData;
    }

    @Override
    @NotNull
    public List<ClassData> computeInterfaces() throws IOException {
        ClassDataProvider prov = this.prov();
        ArrayList<ClassData> res = new ArrayList<ClassData>();
        for (String inter : this.node.interfaces) {
            ClassData interfaceData = prov.findClass(inter);
            if (interfaceData != null) {
                res.add(interfaceData);
                continue;
            }
            if (!this.isRequireFullClasspath()) continue;
            throw new HypoException("Unable to resolve class data binding for '" + inter + "' which is listed as an interface for '" + this.name() + "'");
        }
        return res;
    }

    @Override
    @NotNull
    public List<FieldData> computeFields() {
        ArrayList<FieldData> res = new ArrayList<FieldData>();
        for (FieldNode field : this.node.fields) {
            res.add(new AsmFieldData(this, field));
        }
        return res;
    }

    @Override
    @NotNull
    public List<MethodData> computeMethods() {
        ArrayList<MethodData> res = new ArrayList<MethodData>();
        for (MethodNode method : this.node.methods) {
            if (method.name.equals("<init>")) {
                res.add(new AsmConstructorData(this, method));
                continue;
            }
            res.add(new AsmMethodData(this, method));
        }
        return res;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static AsmClassData readFile(byte @NotNull [] classData) {
        ClassNode node = new ClassNode(589824);
        new ClassReader(classData).accept(node, 0);
        return new AsmClassData(node);
    }
}

