/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl.representations;

import daomephsta.unpick.api.IClassResolver;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;

public class TargetMethods
implements Iterable<TargetMethod> {
    private final Map<String, TargetMethod> methods;
    private final IClassResolver classResolver;

    private TargetMethods(IClassResolver classResolver, Map<String, TargetMethod> methods) {
        this.classResolver = classResolver;
        this.methods = methods;
    }

    public static Builder builder(IClassResolver classResolver) {
        return new Builder(classResolver);
    }

    public boolean targets(String methodOwner, String methodName, String methodDescriptor) {
        TargetMethod targetMethod = this.methods.get(methodName + methodDescriptor);
        if (targetMethod == null) {
            return false;
        }
        return targetMethod.implementedBy(this.classResolver, methodOwner);
    }

    public boolean targetsParameter(String methodOwner, String methodName, String methodDescriptor, int parameterIndex) {
        TargetMethod targetMethod = this.methods.get(methodName + methodDescriptor);
        return targetMethod.hasParameterConstantGroup(parameterIndex);
    }

    public boolean targetsReturn(String methodOwner, String methodName, String methodDescriptor) {
        TargetMethod targetMethod = this.methods.get(methodName + methodDescriptor);
        return targetMethod.hasReturnConstantGroup();
    }

    public String getParameterConstantGroup(String methodOwner, String methodName, String methodDescriptor, int parameterIndex) {
        TargetMethod targetMethod = this.methods.get(methodName + methodDescriptor);
        return targetMethod.getParameterConstantGroup(parameterIndex);
    }

    public String getReturnConstantGroup(String methodOwner, String methodName, String methodDescriptor) {
        TargetMethod targetMethod = this.methods.get(methodName + methodDescriptor);
        return targetMethod.getReturnConstantGroup();
    }

    @Override
    public Iterator<TargetMethod> iterator() {
        return this.methods.values().iterator();
    }

    public String toString() {
        return String.format("TargetMethods [methods=%s]", this.methods);
    }

    public static class Builder {
        private final IClassResolver classResolver;
        private final Map<String, TargetMethod> targetMethods = new HashMap<String, TargetMethod>();

        private Builder(IClassResolver classResolver) {
            this.classResolver = classResolver;
        }

        public TargetMethodBuilder targetMethod(String owner, String name, Type descriptor) {
            return new TargetMethodBuilder(this, owner, name, descriptor);
        }

        public TargetMethods build() {
            return new TargetMethods(this.classResolver, this.targetMethods);
        }
    }

    public static class TargetMethod {
        private final String declarator;
        private final String name;
        private final Set<String> implementors = new HashSet<String>();
        private final Set<String> nonimplementors = new HashSet<String>();
        private final Type descriptor;
        private final Map<Integer, String> parameterConstantGroups;
        private final String returnConstantGroup;

        public TargetMethod(String owner, String name, Type descriptor, Map<Integer, String> parameterConstantGroups, String returnConstantGroup) {
            this.declarator = owner;
            this.name = name;
            this.descriptor = descriptor;
            this.parameterConstantGroups = parameterConstantGroups;
            this.returnConstantGroup = returnConstantGroup;
        }

        public String getParameterConstantGroup(int parameterIndex) {
            return this.parameterConstantGroups.get(parameterIndex);
        }

        public boolean hasParameterConstantGroup(int parameterIndex) {
            return this.parameterConstantGroups.containsKey(parameterIndex);
        }

        public boolean hasReturnConstantGroup() {
            return this.returnConstantGroup != null;
        }

        public String getReturnConstantGroup() {
            return this.returnConstantGroup;
        }

        public boolean implementedBy(IClassResolver classResolver, String classInternalName) {
            if (this.declarator.equals(classInternalName) || this.implementors.contains(classInternalName)) {
                return true;
            }
            if (this.nonimplementors.contains(classInternalName)) {
                return false;
            }
            if (InheritanceChecker.inheritsFrom(589824, classResolver, classInternalName, this.declarator)) {
                this.implementors.add(classInternalName);
                return true;
            }
            this.nonimplementors.add(classInternalName);
            return false;
        }

        public String toString() {
            return String.format("TargetMethod {Qualified Name: %s.%s, Descriptor: %s, Parameter Constant Groups: %s}", this.declarator, this.name, this.descriptor, this.parameterConstantGroups);
        }
    }

    public static class DuplicateMappingException
    extends RuntimeException {
        public DuplicateMappingException(String message) {
            super(message);
        }
    }

    private static class InheritanceChecker
    extends ClassVisitor {
        private final IClassResolver classResolver;
        private final String targetOwner;
        private boolean result = false;

        public static boolean inheritsFrom(int api, IClassResolver classResolver, String clazz, String targetOwner) {
            try {
                ClassReader classReader = classResolver.resolveClass(clazz);
                InheritanceChecker inheritanceChecker = new InheritanceChecker(api, classResolver, targetOwner);
                classReader.accept(inheritanceChecker, 0);
                return inheritanceChecker.result;
            }
            catch (IClassResolver.ClassResolutionException e) {
                e.printStackTrace();
                return false;
            }
        }

        public InheritanceChecker(int api, IClassResolver classResolver, String targetOwner) {
            super(api);
            this.classResolver = classResolver;
            this.targetOwner = targetOwner;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if (this.targetOwner.equals(name)) {
                this.result = true;
                return;
            }
            try {
                if (superName != null && !superName.equals("java/lang/Object")) {
                    ClassReader classReader = this.classResolver.resolveClass(superName);
                    classReader.accept(this, 0);
                    if (this.result) {
                        return;
                    }
                }
                if (interfaces != null) {
                    for (String iface : interfaces) {
                        ClassReader classReader = this.classResolver.resolveClass(iface);
                        classReader.accept(this, 0);
                        if (!this.result) continue;
                        return;
                    }
                }
            }
            catch (IClassResolver.ClassResolutionException e) {
                e.printStackTrace();
            }
        }
    }

    public static class TargetMethodBuilder {
        private final Builder parent;
        private final String owner;
        private final String name;
        private final Type descriptor;
        private final Map<Integer, String> parameterConstantGroups;
        private String returnConstantGroup;

        TargetMethodBuilder(Builder parent, String owner, String name, Type descriptor) {
            this.parent = parent;
            this.owner = owner;
            this.name = name;
            this.descriptor = descriptor;
            this.parameterConstantGroups = new HashMap<Integer, String>(descriptor.getArgumentTypes().length);
        }

        public TargetMethodBuilder parameterGroup(int parameterIndex, String constantGroup) {
            String existingGroup = this.parameterConstantGroups.putIfAbsent(parameterIndex, constantGroup);
            if (existingGroup != null) {
                throw new DuplicateMappingException("Parameter " + parameterIndex + " is already mapped to constant group " + existingGroup);
            }
            return this;
        }

        public TargetMethodBuilder returnGroup(String constantGroup) {
            if (this.returnConstantGroup != null) {
                throw new DuplicateMappingException("Return is already mapped to constant group " + this.returnConstantGroup);
            }
            this.returnConstantGroup = constantGroup;
            return this;
        }

        public Builder add() {
            this.parent.targetMethods.put(this.name + this.descriptor, new TargetMethod(this.owner, this.name, this.descriptor, this.parameterConstantGroups, this.returnConstantGroup));
            return this.parent;
        }
    }
}

