/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl.representations;

import daomephsta.unpick.impl.AbstractInsnNodes;
import daomephsta.unpick.impl.representations.AbstractConstantGroup;
import daomephsta.unpick.impl.representations.ReplacementInstructionGenerator;
import daomephsta.unpick.impl.representations.SimpleConstantDefinition;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.objectweb.asm.tree.FieldInsnNode;

public class SimpleConstantGroup
extends AbstractConstantGroup<SimpleConstantDefinition> {
    private static final Logger LOGGER = Logger.getLogger("unpick");
    private final Map<Object, SimpleConstantDefinition> resolvedConstantDefinitions = new HashMap<Object, SimpleConstantDefinition>();

    public SimpleConstantGroup(String id) {
        super(id);
    }

    @Override
    public void add(SimpleConstantDefinition constantDefinition) {
        LOGGER.info("Loaded " + constantDefinition + " into '" + this.getId() + "'");
        if (constantDefinition.isResolved()) {
            this.acceptResolved(constantDefinition);
        } else {
            this.unresolvedConstantDefinitions.add(constantDefinition);
        }
    }

    @Override
    public boolean canReplace(ReplacementInstructionGenerator.Context context) {
        this.resolveAllConstants(context.getConstantResolver());
        return AbstractInsnNodes.hasLiteralValue(context.getArgSeed()) && this.resolvedConstantDefinitions.containsKey(AbstractInsnNodes.getLiteralValue(context.getArgSeed()));
    }

    @Override
    public void generateReplacements(ReplacementInstructionGenerator.Context context) {
        this.resolveAllConstants(context.getConstantResolver());
        Object literalValue = AbstractInsnNodes.getLiteralValue(context.getArgSeed());
        SimpleConstantDefinition constantDefinition = this.resolvedConstantDefinitions.get(literalValue);
        context.getReplacementSet().addReplacement(context.getArgSeed(), new FieldInsnNode(178, constantDefinition.getOwner(), constantDefinition.getName(), constantDefinition.getDescriptorString()));
    }

    @Override
    protected void acceptResolved(SimpleConstantDefinition definition) {
        this.resolvedConstantDefinitions.put(definition.getValue(), definition);
    }

    public String toString() {
        return String.format("ConstantGroup [Resolved Constant Definitions: %s, Unresolved Constant Definitions: %s]", this.resolvedConstantDefinitions, this.unresolvedConstantDefinitions);
    }
}

