/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl.representations;

import daomephsta.unpick.impl.AbstractInsnNodes;
import daomephsta.unpick.impl.IntegerType;
import daomephsta.unpick.impl.representations.AbstractConstantGroup;
import daomephsta.unpick.impl.representations.FlagDefinition;
import daomephsta.unpick.impl.representations.ReplacementInstructionGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;

public class FlagConstantGroup
extends AbstractConstantGroup<FlagDefinition> {
    private static final Logger LOGGER = Logger.getLogger("unpick");
    private final Collection<FlagDefinition> resolvedConstantDefinitions = new ArrayList<FlagDefinition>();

    public FlagConstantGroup(String id) {
        super(id);
    }

    @Override
    public void add(FlagDefinition flagDefinition) {
        LOGGER.info("Loaded " + flagDefinition + " into '" + this.getId() + "'");
        if (flagDefinition.isResolved()) {
            this.resolvedConstantDefinitions.add(flagDefinition);
        } else {
            this.unresolvedConstantDefinitions.add(flagDefinition);
        }
    }

    @Override
    public boolean canReplace(ReplacementInstructionGenerator.Context context) {
        if (!AbstractInsnNodes.hasLiteralValue(context.getArgSeed())) {
            return false;
        }
        Object literalObj = AbstractInsnNodes.getLiteralValue(context.getArgSeed());
        return literalObj instanceof Integer || literalObj instanceof Long;
    }

    @Override
    public void generateReplacements(ReplacementInstructionGenerator.Context context) {
        ArrayList<FlagDefinition> constants;
        ArrayList<FlagDefinition> negatedConstants;
        Number literalNum = (Number)AbstractInsnNodes.getLiteralValue(context.getArgSeed());
        IntegerType integerType = IntegerType.from(literalNum);
        this.resolveAllConstants(context.getConstantResolver());
        long literal = integerType.toUnsignedLong(literalNum);
        if (literal == 0L || literal == -1L) {
            for (FlagDefinition constant : this.resolvedConstantDefinitions) {
                if (integerType.toUnsignedLong(constant.getValue()) != literal) continue;
                context.getReplacementSet().addReplacement(context.getArgSeed(), new FieldInsnNode(178, constant.getOwner(), constant.getName(), constant.getDescriptorString()));
                break;
            }
            return;
        }
        ArrayList<FlagDefinition> orConstants = new ArrayList<FlagDefinition>();
        long orResidual = this.getConstantsEncompassing(literal, integerType, orConstants);
        long negatedLiteral = integerType.toUnsignedLong(integerType.binaryNegate(literalNum));
        long negatedResidual = this.getConstantsEncompassing(negatedLiteral, integerType, negatedConstants = new ArrayList<FlagDefinition>());
        boolean negated = negatedResidual == 0L && (orResidual != 0L || negatedConstants.size() < orConstants.size());
        ArrayList<FlagDefinition> arrayList = constants = negated ? negatedConstants : orConstants;
        if (constants.isEmpty()) {
            return;
        }
        long residual = negated ? negatedResidual : orResidual;
        InsnList replacement = new InsnList();
        boolean firstConstant = true;
        for (FlagDefinition constant : constants) {
            replacement.add(new FieldInsnNode(178, constant.getOwner(), constant.getName(), constant.getDescriptorString()));
            if (firstConstant) {
                firstConstant = false;
                continue;
            }
            replacement.add(integerType.createOrInsn());
        }
        if (residual != 0L) {
            replacement.add(integerType.createLiteralPushInsn(residual));
            replacement.add(integerType.createOrInsn());
        }
        if (negated) {
            replacement.add(integerType.createLiteralPushInsn(-1L));
            replacement.add(integerType.createXorInsn());
        }
        context.getReplacementSet().addReplacement(context.getArgSeed(), replacement);
    }

    private long getConstantsEncompassing(long literal, IntegerType integerType, List<FlagDefinition> constantsOut) {
        long residual = literal;
        for (FlagDefinition constant : this.resolvedConstantDefinitions) {
            long val = integerType.toUnsignedLong(constant.getValue());
            if ((val & residual) == 0L || (val & literal) != val) continue;
            constantsOut.add(constant);
            if ((residual &= val ^ 0xFFFFFFFFFFFFFFFFL) != 0L) continue;
            break;
        }
        return residual;
    }

    @Override
    protected void acceptResolved(FlagDefinition definition) {
        this.resolvedConstantDefinitions.add(definition);
    }

    public String toString() {
        return String.format("FlagGroup [Resolved Flag Definitions: %s, Unresolved Flag Definitions: %s]", this.resolvedConstantDefinitions, this.unresolvedConstantDefinitions);
    }
}

