/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl.representations;

import daomephsta.unpick.api.constantresolvers.IConstantResolver;
import daomephsta.unpick.impl.representations.AbstractConstantDefinition;
import daomephsta.unpick.impl.representations.ReplacementInstructionGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;

public abstract class AbstractConstantGroup<T extends AbstractConstantDefinition<T>>
implements ReplacementInstructionGenerator {
    private static final Logger LOGGER = Logger.getLogger("unpick");
    protected final Collection<T> unresolvedConstantDefinitions = new ArrayList<T>();
    private final String id;

    public AbstractConstantGroup(String id) {
        this.id = id;
    }

    public abstract void add(T var1);

    protected final void resolveAllConstants(IConstantResolver constantResolver) {
        if (!this.unresolvedConstantDefinitions.isEmpty()) {
            for (AbstractConstantDefinition definition : this.unresolvedConstantDefinitions) {
                try {
                    this.acceptResolved(definition.resolve(constantResolver));
                }
                catch (AbstractConstantDefinition.ResolutionException e) {
                    LOGGER.warning(e.getMessage());
                }
            }
            this.unresolvedConstantDefinitions.clear();
        }
    }

    protected abstract void acceptResolved(T var1);

    public String getId() {
        return this.id;
    }
}

