/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl.representations;

import daomephsta.unpick.api.constantresolvers.IConstantResolver;
import daomephsta.unpick.constantmappers.datadriven.parser.UnpickSyntaxException;
import daomephsta.unpick.impl.LiteralType;
import org.objectweb.asm.Type;

public abstract class AbstractConstantDefinition<C extends AbstractConstantDefinition<C>> {
    protected final String owner;
    protected final String name;
    protected Type descriptor;
    protected Object value;

    public AbstractConstantDefinition(String owner, String name) {
        this.owner = owner;
        this.name = name;
    }

    public AbstractConstantDefinition(String owner, String name, Type descriptor, String valueString) {
        this.owner = owner;
        this.name = name;
        this.descriptor = descriptor;
        this.value = this.parseValue(valueString);
    }

    protected Object parseValue(String valueString) {
        try {
            return LiteralType.from(this.descriptor).parse(valueString);
        }
        catch (IllegalArgumentException e) {
            throw new UnpickSyntaxException("Cannot parse value " + valueString + " with descriptor " + this.descriptor, e);
        }
    }

    boolean isResolved() {
        return this.value != null;
    }

    public final C resolve(IConstantResolver constantResolver) throws ResolutionException {
        IConstantResolver.ResolvedConstant resolvedData = constantResolver.resolveConstant(this.owner, this.name);
        if (resolvedData == null) {
            throw new ResolutionException("Could not resolve " + this);
        }
        this.descriptor = (Type)resolvedData.getKey();
        this.setValue(resolvedData.getValue());
        AbstractConstantDefinition self = this;
        return (C)self;
    }

    protected void setValue(Object value) throws ResolutionException {
        this.value = value;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    public Type getDescriptor() {
        return this.descriptor;
    }

    public String getDescriptorString() {
        return this.descriptor.getDescriptor();
    }

    public Object getValue() {
        return this.value;
    }

    public static class ResolutionException
    extends Exception {
        private static final long serialVersionUID = -7161839164703778814L;

        public ResolutionException(String message) {
            super(message);
        }

        public ResolutionException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

