/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl.constantresolvers;

import daomephsta.unpick.api.IClassResolver;
import daomephsta.unpick.api.constantresolvers.IConstantResolver;
import daomephsta.unpick.impl.LiteralType;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Type;

public class BytecodeAnalysisConstantResolver
implements IConstantResolver {
    private static final Set<Type> VALID_CONSTANT_TYPES = Arrays.stream(LiteralType.values()).map(LiteralType::getType).collect(Collectors.toSet());
    private final Map<String, ResolvedConstants> constantDataCache = new HashMap<String, ResolvedConstants>();
    private final IClassResolver classResolver;

    public BytecodeAnalysisConstantResolver(IClassResolver classResolver) {
        this.classResolver = classResolver;
    }

    @Override
    public IConstantResolver.ResolvedConstant resolveConstant(String owner, String name) {
        return this.constantDataCache.computeIfAbsent(owner, this::extractConstants).get(name);
    }

    private ResolvedConstants extractConstants(String owner) {
        ClassReader cr = this.classResolver.resolveClass(owner);
        ResolvedConstants resolvedConstants = new ResolvedConstants(589824);
        cr.accept(resolvedConstants, 0);
        return resolvedConstants;
    }

    private static class ResolvedConstants
    extends ClassVisitor {
        private final Map<String, IConstantResolver.ResolvedConstant> resolvedConstants = new HashMap<String, IConstantResolver.ResolvedConstant>();

        public ResolvedConstants(int api) {
            super(api);
        }

        @Override
        public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
            if (Modifier.isStatic(access) && Modifier.isFinal(access)) {
                Type fieldType = Type.getType(descriptor);
                if (VALID_CONSTANT_TYPES.stream().anyMatch(t2 -> t2.equals(fieldType))) {
                    this.resolvedConstants.put(name, new IConstantResolver.ResolvedConstant(fieldType, value));
                }
            }
            return super.visitField(access, name, descriptor, signature, value);
        }

        public IConstantResolver.ResolvedConstant get(Object key) {
            return this.resolvedConstants.get(key);
        }
    }
}

