/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl.constantmappers.datadriven.parser.v2;

import daomephsta.unpick.constantmappers.datadriven.parser.UnpickSyntaxException;
import daomephsta.unpick.constantmappers.datadriven.parser.v2.UnpickV2Reader;
import daomephsta.unpick.impl.representations.FlagConstantGroup;
import daomephsta.unpick.impl.representations.FlagDefinition;
import daomephsta.unpick.impl.representations.ReplacementInstructionGenerator;
import daomephsta.unpick.impl.representations.SimpleConstantDefinition;
import daomephsta.unpick.impl.representations.SimpleConstantGroup;
import daomephsta.unpick.impl.representations.TargetMethods;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.function.IntSupplier;
import org.objectweb.asm.Type;

public class V2Parser
implements UnpickV2Reader.Visitor {
    private final Map<String, ReplacementInstructionGenerator> constantGroups;
    private final TargetMethods.Builder targetMethodsBuilder;
    private int lineNumber;

    public V2Parser(Map<String, ReplacementInstructionGenerator> constantGroups, TargetMethods.Builder targetMethodsBuilder) {
        this.constantGroups = constantGroups;
        this.targetMethodsBuilder = targetMethodsBuilder;
    }

    public static void parse(InputStream mappingSource, Map<String, ReplacementInstructionGenerator> constantGroups, TargetMethods.Builder targetMethodsBuilder) throws IOException {
        try (UnpickV2Reader unpickDefinitions = new UnpickV2Reader(mappingSource);){
            unpickDefinitions.accept(new V2Parser(constantGroups, targetMethodsBuilder));
        }
    }

    @Override
    public void visitLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    @Override
    public void visitSimpleConstantDefinition(String groupId, String owner, String name, String value, String descriptor) {
        ReplacementInstructionGenerator group = this.constantGroups.computeIfAbsent(groupId, k -> new SimpleConstantGroup((String)k));
        SimpleConstantDefinition constant = this.createSimpleConstantDefinition(owner, name, value, descriptor);
        if (!(group instanceof SimpleConstantGroup)) {
            throw new UnpickSyntaxException(this.lineNumber, String.format("Cannot add simple constant to %s '%s'", group.getClass().getSimpleName(), groupId));
        }
        ((SimpleConstantGroup)group).add(constant);
    }

    private SimpleConstantDefinition createSimpleConstantDefinition(String owner, String name, String value, String descriptor) {
        if (value != null && descriptor != null) {
            try {
                return new SimpleConstantDefinition(owner, name, Type.getType(descriptor), value);
            }
            catch (IllegalArgumentException e) {
                throw new UnpickSyntaxException(this.lineNumber, "Unable to parse descriptor " + descriptor);
            }
        }
        return new SimpleConstantDefinition(owner, name);
    }

    @Override
    public void visitFlagConstantDefinition(String groupId, String owner, String name, String value, String descriptor) {
        ReplacementInstructionGenerator group = this.constantGroups.computeIfAbsent(groupId, k -> new FlagConstantGroup((String)k));
        FlagDefinition constant = this.createFlagDefinition(owner, name, value, descriptor);
        if (!(group instanceof FlagConstantGroup)) {
            throw new UnpickSyntaxException(this.lineNumber, String.format("Cannot add flag constant to %s '%s'", group.getClass().getSimpleName(), groupId));
        }
        ((FlagConstantGroup)group).add(constant);
    }

    private FlagDefinition createFlagDefinition(String owner, String name, String value, String descriptor) {
        if (value != null && descriptor != null) {
            try {
                return new FlagDefinition(owner, name, Type.getType(descriptor), value);
            }
            catch (IllegalArgumentException e) {
                throw new UnpickSyntaxException(this.lineNumber, "Unable to parse descriptor " + descriptor);
            }
        }
        return new FlagDefinition(owner, name);
    }

    @Override
    public UnpickV2Reader.TargetMethodDefinitionVisitor visitTargetMethodDefinition(String owner, String name, String descriptor) {
        return new TargetMethodParser(this.targetMethodsBuilder.targetMethod(owner, name, Type.getType(descriptor)), () -> this.lineNumber);
    }

    private static class TargetMethodParser
    implements UnpickV2Reader.TargetMethodDefinitionVisitor {
        private final TargetMethods.TargetMethodBuilder targetMethodBuilder;
        private final IntSupplier lineNumber;

        public TargetMethodParser(TargetMethods.TargetMethodBuilder targetMethodBuilder, IntSupplier lineNumber) {
            this.targetMethodBuilder = targetMethodBuilder;
            this.lineNumber = lineNumber;
        }

        @Override
        public void visitParameterGroupDefinition(int parameterIndex, String group) {
            try {
                this.targetMethodBuilder.parameterGroup(parameterIndex, group);
            }
            catch (TargetMethods.DuplicateMappingException e) {
                throw new UnpickSyntaxException(this.lineNumber.getAsInt(), e.getMessage());
            }
        }

        @Override
        public void visitReturnGroupDefinition(String group) {
            try {
                this.targetMethodBuilder.returnGroup(group);
            }
            catch (TargetMethods.DuplicateMappingException e) {
                throw new UnpickSyntaxException(this.lineNumber.getAsInt(), e.getMessage());
            }
        }

        @Override
        public void endVisit() {
            this.targetMethodBuilder.add();
        }
    }
}

