/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl.constantmappers.datadriven.parser;

import daomephsta.unpick.constantmappers.datadriven.parser.UnpickSyntaxException;
import daomephsta.unpick.impl.representations.FlagConstantGroup;
import daomephsta.unpick.impl.representations.FlagDefinition;
import daomephsta.unpick.impl.representations.ReplacementInstructionGenerator;
import daomephsta.unpick.impl.representations.SimpleConstantDefinition;
import daomephsta.unpick.impl.representations.SimpleConstantGroup;
import daomephsta.unpick.impl.representations.TargetMethods;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;
import org.objectweb.asm.Type;

public enum V1Parser {
    INSTANCE;

    private static final Pattern WHITESPACE_SPLITTER;

    public void parse(InputStream mappingSource, Map<String, ReplacementInstructionGenerator> constantGroups, TargetMethods.Builder targetMethodsBuilder) throws IOException {
        try (LineNumberReader reader = new LineNumberReader(new InputStreamReader(mappingSource));){
            String line = "";
            block15: while ((line = reader.readLine()) != null) {
                String[] tokens;
                if ((line = this.stripComment(line).trim()).isEmpty() || (tokens = this.tokenize(line)).length == 0) continue;
                switch (tokens[0]) {
                    case "constant": {
                        if (tokens.length != 4 && tokens.length != 6) {
                            throw new UnpickSyntaxException(reader.getLineNumber(), "Unexpected token count. Expected 4 or 6. Found " + tokens.length);
                        }
                        String group = tokens[1];
                        SimpleConstantDefinition parsedConstant = this.parseConstantDefinition(tokens, reader.getLineNumber());
                        ReplacementInstructionGenerator constantGroup = constantGroups.get(group);
                        if (constantGroup == null) {
                            constantGroup = new SimpleConstantGroup(group);
                            constantGroups.put(group, constantGroup);
                        }
                        if (constantGroup instanceof SimpleConstantGroup) {
                            ((SimpleConstantGroup)constantGroup).add(parsedConstant);
                            continue block15;
                        }
                        throw new UnpickSyntaxException(reader.getLineNumber(), "Cannot add simple constant to non-simple constant group of type " + constantGroup.getClass().getSimpleName());
                    }
                    case "flag": {
                        if (tokens.length != 4 && tokens.length != 6) {
                            throw new UnpickSyntaxException(reader.getLineNumber(), "Unexpected token count. Expected 4 or 6. Found " + tokens.length);
                        }
                        String group = tokens[1];
                        FlagDefinition parsedFlag = this.parseFlagDefinition(tokens, reader.getLineNumber());
                        ReplacementInstructionGenerator constantGroup = constantGroups.get(group);
                        if (constantGroup == null) {
                            constantGroup = new FlagConstantGroup(group);
                            constantGroups.put(group, constantGroup);
                        }
                        if (constantGroup instanceof FlagConstantGroup) {
                            ((FlagConstantGroup)constantGroup).add(parsedFlag);
                            continue block15;
                        }
                        throw new UnpickSyntaxException(reader.getLineNumber(), "Cannot add flag to non-flag group of type " + constantGroup.getClass().getSimpleName());
                    }
                    case "unpick": {
                        this.parseTargetMethodDefinition(targetMethodsBuilder, tokens, reader.getLineNumber());
                        continue block15;
                    }
                }
                throw new UnpickSyntaxException(reader.getLineNumber(), "Unknown start token " + tokens[0]);
            }
        }
    }

    private String stripComment(String in) {
        int c = in.indexOf(35);
        return c == -1 ? in : in.substring(0, c);
    }

    private String[] tokenize(String in) {
        ArrayList<String> result = new ArrayList<String>();
        for (String s2 : WHITESPACE_SPLITTER.split(in)) {
            if (s2.isEmpty()) continue;
            result.add(s2);
        }
        return result.toArray(new String[0]);
    }

    private SimpleConstantDefinition parseConstantDefinition(String[] tokens, int lineNumber) {
        String owner = tokens[2];
        String name = tokens[3];
        if (tokens.length > 4) {
            try {
                Type descriptor = Type.getType(tokens[5]);
                String value = tokens[4];
                return new SimpleConstantDefinition(owner, name, descriptor, value);
            }
            catch (IllegalArgumentException e) {
                throw new UnpickSyntaxException(lineNumber, "Unable to parse descriptor " + tokens[4]);
            }
        }
        return new SimpleConstantDefinition(owner, name);
    }

    private FlagDefinition parseFlagDefinition(String[] tokens, int lineNumber) {
        String owner = tokens[2];
        String name = tokens[3];
        if (tokens.length > 4) {
            try {
                Type descriptor = Type.getType(tokens[5]);
                String value = tokens[4];
                return new FlagDefinition(owner, name, descriptor, value);
            }
            catch (IllegalArgumentException e) {
                throw new UnpickSyntaxException(lineNumber, "Unable to parse descriptor " + tokens[4]);
            }
        }
        return new FlagDefinition(owner, name);
    }

    private void parseTargetMethodDefinition(TargetMethods.Builder targetMethodsBuilder, String[] tokens, int lineNumber) {
        if (tokens.length < 4 || tokens.length % 2 != 0) {
            throw new UnpickSyntaxException(lineNumber, "Unexpected token count. Expected an even number greater than or equal to 4. Found " + tokens.length);
        }
        String owner = tokens[1];
        String name = tokens[2];
        try {
            Type methodType = Type.getMethodType(tokens[3]);
            TargetMethods.TargetMethodBuilder targetMethodBuilder = targetMethodsBuilder.targetMethod(owner, name, methodType);
            for (int p = 5; p < tokens.length; p += 2) {
                try {
                    int parameterIndex = Integer.parseInt(tokens[p - 1]);
                    targetMethodBuilder.parameterGroup(parameterIndex, tokens[p]);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new UnpickSyntaxException(lineNumber, "Could not parse " + tokens[p - 1] + " as integer", e);
                }
            }
            targetMethodBuilder.add();
        }
        catch (IllegalArgumentException e) {
            throw new UnpickSyntaxException(lineNumber, "Unable to parse method descriptor " + tokens[3]);
        }
    }

    static {
        WHITESPACE_SPLITTER = Pattern.compile("\\s");
    }
}

