/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl.constantmappers.datadriven;

import daomephsta.unpick.api.IClassResolver;
import daomephsta.unpick.constantmappers.datadriven.parser.UnpickSyntaxException;
import daomephsta.unpick.impl.constantmappers.SimpleAbstractConstantMapper;
import daomephsta.unpick.impl.constantmappers.datadriven.parser.V1Parser;
import daomephsta.unpick.impl.constantmappers.datadriven.parser.v2.V2Parser;
import daomephsta.unpick.impl.representations.ReplacementInstructionGenerator;
import daomephsta.unpick.impl.representations.TargetMethods;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.Logger;

public class DataDrivenConstantMapper
extends SimpleAbstractConstantMapper {
    private static final Logger LOGGER = Logger.getLogger("unpick");
    private final TargetMethods targetMethods;

    public DataDrivenConstantMapper(IClassResolver classResolver, InputStream ... mappingSources) {
        super(new HashMap<String, ReplacementInstructionGenerator>());
        TargetMethods.Builder targetMethodsBuilder = TargetMethods.builder(classResolver);
        block6: for (InputStream mappingSource : mappingSources) {
            try {
                byte[] version = new byte[2];
                mappingSource.read(version);
                if (version[0] == 118) {
                    switch (version[1]) {
                        case 49: {
                            V1Parser.INSTANCE.parse(mappingSource, this.constantGroups, targetMethodsBuilder);
                            continue block6;
                        }
                        case 50: {
                            V2Parser.parse(mappingSource, this.constantGroups, targetMethodsBuilder);
                            continue block6;
                        }
                        default: {
                            throw new UnpickSyntaxException(1, "Unknown version " + (char)version[1]);
                        }
                    }
                }
                throw new UnpickSyntaxException(1, "Missing version");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.targetMethods = targetMethodsBuilder.build();
        LOGGER.info("Loaded " + this.targetMethods);
    }

    @Override
    protected TargetMethods getTargetMethods() {
        return this.targetMethods;
    }
}

