/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl;

import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.analysis.SourceValue;
import org.objectweb.asm.tree.analysis.Value;

public class UnpickValue
implements Value {
    private final SourceValue sourceValue;
    private Set<Integer> parameterSources;
    private Set<MethodUsage> methodUsages;
    private Set<AbstractInsnNode> usages;

    public UnpickValue(SourceValue sourceValue) {
        this.sourceValue = sourceValue;
        this.parameterSources = new HashSet<Integer>();
        this.methodUsages = new HashSet<MethodUsage>();
        this.usages = new HashSet<AbstractInsnNode>();
    }

    public UnpickValue(SourceValue sourceValue, UnpickValue cloneOf) {
        this.sourceValue = sourceValue;
        this.parameterSources = cloneOf.getParameterSources();
        this.methodUsages = cloneOf.getMethodUsages();
        this.usages = cloneOf.getUsages();
    }

    @Override
    public int getSize() {
        return this.sourceValue.getSize();
    }

    public SourceValue getSourceValue() {
        return this.sourceValue;
    }

    public Set<Integer> getParameterSources() {
        return this.parameterSources;
    }

    public Set<MethodUsage> getMethodUsages() {
        return this.methodUsages;
    }

    public Set<AbstractInsnNode> getUsages() {
        return this.usages;
    }

    void setParameterSources(Set<Integer> parameterSources) {
        this.parameterSources = parameterSources;
    }

    void setMethodUsages(Set<MethodUsage> methodUsages) {
        this.methodUsages = methodUsages;
    }

    void setUsages(Set<AbstractInsnNode> usages) {
        this.usages = usages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnpickValue that = (UnpickValue)o;
        if (!this.sourceValue.equals(that.sourceValue)) {
            return false;
        }
        if (!this.parameterSources.equals(that.parameterSources)) {
            return false;
        }
        if (!this.methodUsages.equals(that.methodUsages)) {
            return false;
        }
        return this.usages.equals(that.usages);
    }

    public int hashCode() {
        int result = this.sourceValue.hashCode();
        result = 31 * result + this.parameterSources.hashCode();
        result = 31 * result + this.methodUsages.hashCode();
        result = 31 * result + this.usages.hashCode();
        return result;
    }

    public static class MethodUsage {
        private final AbstractInsnNode methodInvocation;
        private final int paramIndex;

        public MethodUsage(AbstractInsnNode methodInvocation, int paramIndex) {
            this.methodInvocation = methodInvocation;
            this.paramIndex = paramIndex;
        }

        public AbstractInsnNode getMethodInvocation() {
            return this.methodInvocation;
        }

        public int getParamIndex() {
            return this.paramIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodUsage that = (MethodUsage)o;
            if (this.paramIndex != that.paramIndex) {
                return false;
            }
            return this.methodInvocation.equals(that.methodInvocation);
        }

        public int hashCode() {
            int result = this.methodInvocation.hashCode();
            result = 31 * result + this.paramIndex;
            return result;
        }

        public String toString() {
            return "MethodUsage{methodInvocation=" + this.methodInvocation + ", paramIndex=" + this.paramIndex + '}';
        }
    }
}

