/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl;

import daomephsta.unpick.impl.InstructionFactory;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;

public enum IntegerType {
    BYTE(Byte.class, Byte.TYPE, Type.BYTE_TYPE, 126, 172){

        @Override
        public AbstractInsnNode createLiteralPushInsn(long literal) {
            return InstructionFactory.pushesInt((byte)literal);
        }

        @Override
        public void appendLiteralPushInsn(MethodVisitor mv, long literal) {
            InstructionFactory.pushesInt(mv, (byte)literal);
        }

        @Override
        public Number box(long value) {
            return (byte)value;
        }

        @Override
        public Number binaryNegate(Number value) {
            return ~value.byteValue();
        }

        @Override
        public long toUnsignedLong(Number value) {
            return Byte.toUnsignedLong(value.byteValue());
        }

        @Override
        public Number parse(String valueString) {
            return Byte.parseByte(valueString);
        }
    }
    ,
    SHORT(Short.class, Short.TYPE, Type.SHORT_TYPE, 126, 172){

        @Override
        public AbstractInsnNode createLiteralPushInsn(long literal) {
            return InstructionFactory.pushesInt((short)literal);
        }

        @Override
        public void appendLiteralPushInsn(MethodVisitor mv, long literal) {
            InstructionFactory.pushesInt(mv, (short)literal);
        }

        @Override
        public Number box(long value) {
            return (short)value;
        }

        @Override
        public Number binaryNegate(Number value) {
            return ~value.shortValue();
        }

        @Override
        public long toUnsignedLong(Number value) {
            return Short.toUnsignedLong(value.shortValue());
        }

        @Override
        public Number parse(String valueString) {
            return Short.parseShort(valueString);
        }
    }
    ,
    INT(Integer.class, Integer.TYPE, Type.INT_TYPE, 126, 172){

        @Override
        public AbstractInsnNode createLiteralPushInsn(long literal) {
            return InstructionFactory.pushesInt((int)literal);
        }

        @Override
        public void appendLiteralPushInsn(MethodVisitor mv, long literal) {
            InstructionFactory.pushesInt(mv, (int)literal);
        }

        @Override
        public Number box(long value) {
            return (int)value;
        }

        @Override
        public Number binaryNegate(Number value) {
            return ~value.intValue();
        }

        @Override
        public long toUnsignedLong(Number value) {
            return Integer.toUnsignedLong(value.intValue());
        }

        @Override
        public Number parse(String valueString) {
            return Integer.parseInt(valueString);
        }
    }
    ,
    LONG(Long.class, Long.TYPE, Type.LONG_TYPE, 127, 173){

        @Override
        public AbstractInsnNode createLiteralPushInsn(long literal) {
            return InstructionFactory.pushesLong(literal);
        }

        @Override
        public void appendLiteralPushInsn(MethodVisitor mv, long literal) {
            InstructionFactory.pushesLong(mv, literal);
        }

        @Override
        public Number box(long value) {
            return value;
        }

        @Override
        public Number binaryNegate(Number value) {
            return value.longValue() ^ 0xFFFFFFFFFFFFFFFFL;
        }

        @Override
        public long toUnsignedLong(Number value) {
            return value.longValue();
        }

        @Override
        public Number parse(String valueString) {
            return Long.parseLong(valueString);
        }
    };

    private final Class<? extends Number> boxed;
    private final Class<? extends Number> primitive;
    private final Type type;
    private final int logicalOpcodesStart;
    private final int returnOpcode;

    private IntegerType(Class<? extends Number> boxed, Class<? extends Number> primitive, Type type, int logicalOpcodesStart, int returnOpcode) {
        this.boxed = boxed;
        this.primitive = primitive;
        this.type = type;
        this.logicalOpcodesStart = logicalOpcodesStart;
        this.returnOpcode = returnOpcode;
    }

    public static IntegerType from(Type type) {
        for (IntegerType intType : IntegerType.values()) {
            if (intType.type != type) continue;
            return intType;
        }
        throw new IllegalArgumentException(type + " is not one of: " + IntegerType.describeValidTypes());
    }

    public static IntegerType from(Object literal) {
        for (IntegerType type : IntegerType.values()) {
            if (literal.getClass() != type.getBoxClass() && literal.getClass() != type.getPrimitiveClass()) continue;
            return type;
        }
        throw new IllegalArgumentException(literal + " is not one of: " + IntegerType.describeValidTypes());
    }

    private static String describeValidTypes() {
        return Arrays.stream(IntegerType.values()).map(t2 -> t2.name().toLowerCase(Locale.ROOT)).collect(Collectors.joining(", "));
    }

    public AbstractInsnNode createAndInsn() {
        return new InsnNode(this.getAndOpcode());
    }

    public void appendAndInsn(MethodVisitor mv) {
        mv.visitInsn(this.getAndOpcode());
    }

    public int getAndOpcode() {
        return this.logicalOpcodesStart + 0;
    }

    public AbstractInsnNode createOrInsn() {
        return new InsnNode(this.getOrOpcode());
    }

    public void appendOrInsn(MethodVisitor mv) {
        mv.visitInsn(this.getOrOpcode());
    }

    public int getOrOpcode() {
        return this.logicalOpcodesStart + 2;
    }

    public AbstractInsnNode createXorInsn() {
        return new InsnNode(this.getXorOpcode());
    }

    public void appendXorInsn(MethodVisitor mv) {
        mv.visitInsn(this.getXorOpcode());
    }

    public int getXorOpcode() {
        return this.logicalOpcodesStart + 4;
    }

    public AbstractInsnNode createReturnInsn() {
        return new InsnNode(this.getReturnOpcode());
    }

    public void appendReturnInsn(MethodVisitor mv) {
        mv.visitInsn(this.getReturnOpcode());
    }

    public int getReturnOpcode() {
        return this.returnOpcode;
    }

    public abstract AbstractInsnNode createLiteralPushInsn(long var1);

    public abstract void appendLiteralPushInsn(MethodVisitor var1, long var2);

    public String getTypeDescriptor() {
        return this.type.getDescriptor();
    }

    public Class<? extends Number> getBoxClass() {
        return this.boxed;
    }

    public Class<? extends Number> getPrimitiveClass() {
        return this.primitive;
    }

    public abstract Number box(long var1);

    public abstract Number binaryNegate(Number var1);

    public abstract long toUnsignedLong(Number var1);

    public abstract Number parse(String var1);
}

