/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.impl;

import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;

public class InstructionFactory {
    private static final int[] I_OPCODES = new int[]{3, 4, 5, 6, 7, 8};

    public static AbstractInsnNode pushesValue(Object value) {
        if (value instanceof Number) {
            Number number = (Number)value;
            if (number instanceof Long) {
                return InstructionFactory.pushesLong(number.longValue());
            }
            if (number instanceof Double) {
                return InstructionFactory.pushesDouble(number.doubleValue());
            }
            if (number instanceof Float) {
                return InstructionFactory.pushesFloat(number.floatValue());
            }
            return InstructionFactory.pushesInt(number.intValue());
        }
        if (value instanceof Character) {
            return InstructionFactory.pushesChar(((Character)value).charValue());
        }
        if (value instanceof Boolean) {
            return InstructionFactory.pushesBoolean((Boolean)value);
        }
        if (value instanceof String) {
            return InstructionFactory.pushesString((String)value);
        }
        if (value instanceof Type) {
            return InstructionFactory.pushesTypeReference((Type)value);
        }
        throw new UnsupportedOperationException("Pushing reference types is not supported");
    }

    public static void pushesValue(MethodVisitor method, Object value) {
        if (value instanceof Number) {
            Number number = (Number)value;
            if (number instanceof Long) {
                InstructionFactory.pushesLong(method, number.longValue());
            } else if (number instanceof Double) {
                InstructionFactory.pushesDouble(method, number.doubleValue());
            } else if (number instanceof Float) {
                InstructionFactory.pushesFloat(method, number.floatValue());
            } else {
                InstructionFactory.pushesInt(method, number.intValue());
            }
        } else if (value instanceof Character) {
            InstructionFactory.pushesChar(method, ((Character)value).charValue());
        } else if (value instanceof Boolean) {
            InstructionFactory.pushesBoolean(method, (Boolean)value);
        } else if (value instanceof String) {
            InstructionFactory.pushesString(method, (String)value);
        } else if (value instanceof Type) {
            InstructionFactory.pushesTypeReference(method, (Type)value);
        } else {
            throw new UnsupportedOperationException("Pushing reference types is not supported");
        }
    }

    public static AbstractInsnNode pushesBoolean(boolean bool) {
        return new InsnNode(bool ? 4 : 3);
    }

    public static void pushesBoolean(MethodVisitor method, boolean bool) {
        method.visitInsn(bool ? 4 : 3);
    }

    public static AbstractInsnNode pushesChar(char c) {
        return InstructionFactory.pushesInt(c);
    }

    public static void pushesChar(MethodVisitor method, char c) {
        InstructionFactory.pushesInt(method, c);
    }

    public static AbstractInsnNode pushesInt(int i) {
        if (i == -1) {
            return new InsnNode(2);
        }
        if (i >= 0 && i < I_OPCODES.length) {
            return new InsnNode(I_OPCODES[i]);
        }
        if (i >= -128 && i <= 127) {
            return new IntInsnNode(16, i);
        }
        if (i >= Short.MIN_VALUE && i <= Short.MAX_VALUE) {
            return new IntInsnNode(17, i);
        }
        return new LdcInsnNode((Object)i);
    }

    public static void pushesInt(MethodVisitor method, int i) {
        if (i == -1) {
            method.visitInsn(2);
        } else if (i >= 0 && i < I_OPCODES.length) {
            method.visitInsn(I_OPCODES[i]);
        } else if (i >= -128 && i <= 127) {
            method.visitIntInsn(16, i);
        } else if (i >= Short.MIN_VALUE && i <= Short.MAX_VALUE) {
            method.visitIntInsn(17, i);
        } else {
            method.visitLdcInsn(i);
        }
    }

    public static AbstractInsnNode pushesLong(long l) {
        if (l == 0L) {
            return new InsnNode(9);
        }
        if (l == 1L) {
            return new InsnNode(10);
        }
        return new LdcInsnNode(l);
    }

    public static void pushesLong(MethodVisitor method, long l) {
        if (l == 0L) {
            method.visitInsn(9);
        } else if (l == 1L) {
            method.visitInsn(10);
        } else {
            method.visitLdcInsn(l);
        }
    }

    public static AbstractInsnNode pushesFloat(float f) {
        if (f == 0.0f) {
            return new InsnNode(11);
        }
        if (f == 1.0f) {
            return new InsnNode(12);
        }
        if (f == 2.0f) {
            return new InsnNode(13);
        }
        return new LdcInsnNode(Float.valueOf(f));
    }

    public static void pushesFloat(MethodVisitor method, float f) {
        if (f == 0.0f) {
            method.visitInsn(11);
        } else if (f == 1.0f) {
            method.visitInsn(12);
        } else if (f == 2.0f) {
            method.visitInsn(13);
        } else {
            method.visitLdcInsn(Float.valueOf(f));
        }
    }

    public static AbstractInsnNode pushesDouble(double d) {
        if (d == 0.0) {
            return new InsnNode(14);
        }
        if (d == 1.0) {
            return new InsnNode(15);
        }
        return new LdcInsnNode(d);
    }

    public static void pushesDouble(MethodVisitor method, double d) {
        if (d == 0.0) {
            method.visitInsn(14);
        } else if (d == 1.0) {
            method.visitInsn(15);
        } else {
            method.visitLdcInsn(d);
        }
    }

    public static AbstractInsnNode pushesString(String s2) {
        return new LdcInsnNode(s2);
    }

    public static void pushesString(MethodVisitor method, String s2) {
        method.visitLdcInsn(s2);
    }

    public static AbstractInsnNode pushesTypeReference(Type type) {
        return new LdcInsnNode(type);
    }

    public static void pushesTypeReference(MethodVisitor method, Type type) {
        method.visitLdcInsn(type);
    }
}

