/*
 * Decompiled with CFR 0.152.
 */
package daomephsta.unpick.api;

import daomephsta.unpick.api.constantmappers.IConstantMapper;
import daomephsta.unpick.api.constantresolvers.IConstantResolver;
import daomephsta.unpick.impl.AbstractInsnNodes;
import daomephsta.unpick.impl.UnpickInterpreter;
import daomephsta.unpick.impl.UnpickValue;
import daomephsta.unpick.impl.representations.ReplacementInstructionGenerator;
import daomephsta.unpick.impl.representations.ReplacementSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.objectweb.asm.Handle;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Frame;

public class ConstantUninliner {
    private final Logger logger;
    private final IConstantMapper mapper;
    private final IConstantResolver constantResolver;

    public ConstantUninliner(IConstantMapper mapper, IConstantResolver constantResolver) {
        this(mapper, constantResolver, Logger.getLogger("unpick"));
    }

    public ConstantUninliner(IConstantMapper mapper, IConstantResolver constantResolver, Logger logger) {
        this.mapper = mapper;
        this.constantResolver = constantResolver;
        this.logger = logger;
    }

    public void transform(ClassNode classNode) {
        for (MethodNode method : classNode.methods) {
            this.transformMethod(classNode.name, method);
        }
    }

    public void transformMethod(String methodOwner, MethodNode method) {
        this.logger.log(Level.INFO, String.format("Processing %s.%s%s", methodOwner, method.name, method.desc));
        try {
            ReplacementSet replacementSet = new ReplacementSet(method.instructions);
            Frame<UnpickValue>[] frames = new Analyzer<UnpickValue>(new UnpickInterpreter(method)).analyze(methodOwner, method);
            HashMap<AbstractInsnNode, Consumer<ReplacementInstructionGenerator.Context>> mappers = new HashMap<AbstractInsnNode, Consumer<ReplacementInstructionGenerator.Context>>();
            HashSet<AbstractInsnNode> unmapped = new HashSet<AbstractInsnNode>();
            for (int index = 0; index < method.instructions.size(); ++index) {
                Frame<UnpickValue> frame;
                AbstractInsnNode insn = method.instructions.get(index);
                if (!AbstractInsnNodes.hasLiteralValue(insn) || unmapped.contains(insn)) continue;
                Frame<UnpickValue> frame2 = frame = index + 1 >= frames.length ? null : frames[index + 1];
                if (frame == null) continue;
                UnpickValue unpickValue = frame.getStack(frame.getStackSize() - 1);
                Consumer<ReplacementInstructionGenerator.Context> mapper = (Consumer<ReplacementInstructionGenerator.Context>)mappers.get(insn);
                if (mapper == null) {
                    mapper = this.findMapper(methodOwner, method, unpickValue);
                    if (mapper == null) {
                        unmapped.addAll(unpickValue.getUsages());
                    } else {
                        for (AbstractInsnNode usage : unpickValue.getUsages()) {
                            mappers.put(usage, mapper);
                        }
                    }
                }
                if (mapper == null) continue;
                ReplacementInstructionGenerator.Context context = new ReplacementInstructionGenerator.Context(this.constantResolver, replacementSet, insn, method.instructions, frames, this.logger);
                mapper.accept(context);
            }
            replacementSet.apply();
        }
        catch (AnalyzerException e) {
            this.logger.log(Level.WARNING, String.format("Processing %s.%s%s failed", methodOwner, method.name, method.desc), e);
        }
    }

    private Consumer<ReplacementInstructionGenerator.Context> findMapper(String methodOwner, MethodNode method, UnpickValue unpickValue) {
        Consumer<ReplacementInstructionGenerator.Context> ret;
        Iterator<Object> iterator = unpickValue.getParameterSources().iterator();
        while (iterator.hasNext()) {
            int parameterSource = iterator.next();
            ret = this.processParameterSource(methodOwner, method, parameterSource);
            if (ret == null) continue;
            return ret;
        }
        for (UnpickValue.MethodUsage methodUsage : unpickValue.getMethodUsages()) {
            ret = this.processMethodUsage(methodUsage);
            if (ret == null) continue;
            return ret;
        }
        for (AbstractInsnNode usage : unpickValue.getUsages()) {
            ret = this.processUsage(methodOwner, method, usage);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    private Consumer<ReplacementInstructionGenerator.Context> processParameterSource(String methodOwner, MethodNode enclosingMethod, int parameterIndex) {
        if (!this.mapper.targets(methodOwner, enclosingMethod.name, enclosingMethod.desc)) {
            return null;
        }
        if (!this.mapper.targetsParameter(methodOwner, enclosingMethod.name, enclosingMethod.desc, parameterIndex)) {
            return null;
        }
        this.logger.log(Level.INFO, String.format("Using enclosing method %s.%s%s parameter %d", methodOwner, enclosingMethod.name, enclosingMethod.desc, parameterIndex));
        return context -> this.mapper.mapParameter(methodOwner, enclosingMethod.name, enclosingMethod.desc, parameterIndex, (ReplacementInstructionGenerator.Context)context);
    }

    private Consumer<ReplacementInstructionGenerator.Context> processMethodUsage(UnpickValue.MethodUsage methodUsage) {
        if (methodUsage.getMethodInvocation().getOpcode() == 186) {
            InvokeDynamicInsnNode invokeDynamicInsn = (InvokeDynamicInsnNode)methodUsage.getMethodInvocation();
            if ("java/lang/invoke/LambdaMetafactory".equals(invokeDynamicInsn.bsm.getOwner()) && "metafactory".equals(invokeDynamicInsn.bsm.getName())) {
                int paramIndex;
                Handle lambdaMethod = (Handle)invokeDynamicInsn.bsmArgs[1];
                if (!this.mapper.targets(lambdaMethod.getOwner(), lambdaMethod.getName(), lambdaMethod.getDesc())) {
                    return null;
                }
                int kind = lambdaMethod.getTag();
                boolean hasThis = kind != 2 && kind != 4 && kind != 6 && kind != 8;
                int n = paramIndex = hasThis ? methodUsage.getParamIndex() - 1 : methodUsage.getParamIndex();
                if (!this.mapper.targetsParameter(lambdaMethod.getOwner(), lambdaMethod.getName(), lambdaMethod.getDesc(), paramIndex)) {
                    return null;
                }
                this.logger.log(Level.INFO, String.format("Using lambda %s.%s%s captured parameter %d", lambdaMethod.getOwner(), lambdaMethod.getName(), lambdaMethod.getDesc(), paramIndex));
                return context -> this.mapper.mapParameter(lambdaMethod.getOwner(), lambdaMethod.getName(), lambdaMethod.getDesc(), paramIndex, (ReplacementInstructionGenerator.Context)context);
            }
            return null;
        }
        MethodInsnNode methodInsn = (MethodInsnNode)methodUsage.getMethodInvocation();
        if (!this.mapper.targets(methodInsn.owner, methodInsn.name, methodInsn.desc)) {
            return null;
        }
        if (!this.mapper.targetsParameter(methodInsn.owner, methodInsn.name, methodInsn.desc, methodUsage.getParamIndex())) {
            return null;
        }
        this.logger.log(Level.INFO, String.format("Using method invocation %s.%s%s parameter %d", methodInsn.owner, methodInsn.name, methodInsn.desc, methodUsage.getParamIndex()));
        return context -> this.mapper.mapParameter(methodInsn.owner, methodInsn.name, methodInsn.desc, methodUsage.getParamIndex(), (ReplacementInstructionGenerator.Context)context);
    }

    private Consumer<ReplacementInstructionGenerator.Context> processUsage(String methodOwner, MethodNode enclosingMethod, AbstractInsnNode usage) {
        if (usage.getType() == 5) {
            MethodInsnNode method = (MethodInsnNode)usage;
            if (!this.mapper.targets(method.owner, method.name, method.desc)) {
                return null;
            }
            if (!this.mapper.targetsReturn(method.owner, method.name, method.desc)) {
                return null;
            }
            this.logger.log(Level.INFO, String.format("Using method invocation %s.%s%s return type", method.owner, method.name, method.desc));
            return context -> this.mapper.mapReturn(method.owner, method.name, method.desc, (ReplacementInstructionGenerator.Context)context);
        }
        if (usage.getOpcode() >= 172 && usage.getOpcode() <= 177) {
            if (!this.mapper.targets(methodOwner, enclosingMethod.name, enclosingMethod.desc)) {
                return null;
            }
            if (!this.mapper.targetsReturn(methodOwner, enclosingMethod.name, enclosingMethod.desc)) {
                return null;
            }
            this.logger.log(Level.INFO, String.format("Using enclosing method %s.%s%s return type", methodOwner, enclosingMethod.name, enclosingMethod.desc));
            return context -> this.mapper.mapReturn(methodOwner, enclosingMethod.name, enclosingMethod.desc, (ReplacementInstructionGenerator.Context)context);
        }
        return null;
    }
}

