/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.asm.rules.builder;

import io.papermc.asm.rules.RewriteRule;
import io.papermc.asm.rules.builder.RuleFactory;
import io.papermc.asm.rules.builder.matcher.FieldMatcher;
import io.papermc.asm.rules.builder.matcher.MethodMatcher;
import io.papermc.asm.rules.builder.matcher.TargetedMethodMatcher;
import io.papermc.asm.rules.field.FieldRewrites;
import io.papermc.asm.rules.method.MethodRewrites;
import io.papermc.asm.rules.method.StaticRewrite;
import io.papermc.asm.rules.method.StaticRewrites;
import io.papermc.asm.util.Builder;
import java.lang.constant.ClassDesc;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;

class RuleFactoryImpl
implements RuleFactory {
    final Set<Class<?>> owners;
    final List<RewriteRule> rules = new ArrayList<RewriteRule>();

    RuleFactoryImpl(Set<Class<?>> owners) {
        this.owners = Set.copyOf(owners);
    }

    private static <M, B extends Builder<M>> M build(Consumer<? super B> builderConsumer, Supplier<B> supplier) {
        Builder builder = (Builder)supplier.get();
        builderConsumer.accept(builder);
        return (M)builder.build();
    }

    @Override
    public void plainStaticRewrite(ClassDesc newOwner, Consumer<? super MethodMatcher.Builder> builderConsumer) {
        this.addRule(new StaticRewrite.Plain(this.owners, (MethodMatcher)RuleFactoryImpl.build(builderConsumer, MethodMatcher::builder), newOwner));
    }

    @Override
    public void changeParamToSuper(ClassDesc oldParamType, ClassDesc newParamType, Consumer<? super MethodMatcher.Builder> builderConsumer) {
        this.addRule(new MethodRewrites.SuperTypeParam(this.owners, (MethodMatcher)RuleFactoryImpl.build(builderConsumer, MethodMatcher::builder), oldParamType, newParamType));
    }

    @Override
    public void changeParamFuzzy(ClassDesc newOwner, ClassDesc newType, Method staticHandler, Consumer<? super TargetedMethodMatcher.Builder> builderConsumer) {
        this.addRule(new StaticRewrites.FuzzyParam(this.owners, newType, (TargetedMethodMatcher)RuleFactoryImpl.build(builderConsumer, MethodMatcher::targeted), newOwner, RuleFactoryImpl.verify(staticHandler)));
    }

    @Override
    public void changeParamDirect(ClassDesc newOwner, ClassDesc existingParam, Method staticHandler, Consumer<? super TargetedMethodMatcher.Builder> builderConsumer) {
        this.addRule(new StaticRewrites.DirectParam(this.owners, existingParam, (TargetedMethodMatcher)RuleFactoryImpl.build(builderConsumer, MethodMatcher::targeted), newOwner, RuleFactoryImpl.verify(staticHandler)));
    }

    @Override
    public void changeReturnTypeToSub(ClassDesc oldReturnType, ClassDesc newReturnType, Consumer<? super MethodMatcher.Builder> builderConsumer) {
        this.addRule(new MethodRewrites.SubTypeReturn(this.owners, (MethodMatcher)RuleFactoryImpl.build(builderConsumer, MethodMatcher::builder), oldReturnType, newReturnType));
    }

    @Override
    public void changeReturnTypeFuzzy(ClassDesc newOwner, ClassDesc newReturnType, Method staticHandler, Consumer<? super TargetedMethodMatcher.Builder> builderConsumer) {
        this.addRule(StaticRewrites.returnRewrite(this.owners, newReturnType, (TargetedMethodMatcher)RuleFactoryImpl.build(builderConsumer, MethodMatcher::targeted), newOwner, RuleFactoryImpl.verify(staticHandler), StaticRewrites.OBJECT_DESC, false));
    }

    @Override
    public void changeReturnTypeDirect(ClassDesc newOwner, ClassDesc newReturnType, Method staticHandler, Consumer<? super TargetedMethodMatcher.Builder> builderConsumer) {
        this.addRule(StaticRewrites.returnRewrite(this.owners, newReturnType, (TargetedMethodMatcher)RuleFactoryImpl.build(builderConsumer, MethodMatcher::targeted), newOwner, RuleFactoryImpl.verify(staticHandler), newReturnType, false));
    }

    @Override
    public void changeReturnTypeFuzzyWithContext(ClassDesc newOwner, ClassDesc newReturnType, Method staticHandler, Consumer<? super TargetedMethodMatcher.Builder> builderConsumer) {
        this.addRule(StaticRewrites.returnRewrite(this.owners, newReturnType, (TargetedMethodMatcher)RuleFactoryImpl.build(builderConsumer, MethodMatcher::targeted), newOwner, RuleFactoryImpl.verify(staticHandler), StaticRewrites.OBJECT_DESC, true));
    }

    @Override
    public void changeReturnTypeDirectWithContext(ClassDesc newOwner, ClassDesc newReturnType, Method staticHandler, Consumer<? super TargetedMethodMatcher.Builder> builderConsumer) {
        this.addRule(StaticRewrites.returnRewrite(this.owners, newReturnType, (TargetedMethodMatcher)RuleFactoryImpl.build(builderConsumer, MethodMatcher::targeted), newOwner, RuleFactoryImpl.verify(staticHandler), newReturnType, true));
    }

    @Override
    public void renameField(String newName, Consumer<? super FieldMatcher.Builder> builderConsumer) {
        this.addRule(new FieldRewrites.Rename(this.owners, (FieldMatcher)RuleFactoryImpl.build(builderConsumer, FieldMatcher::builder), newName));
    }

    @Override
    public void addRule(RewriteRule rule) {
        this.rules.add(rule);
    }

    private static Method verify(Method staticHandler) {
        if (!Modifier.isStatic(staticHandler.getModifiers())) {
            throw new IllegalArgumentException(staticHandler + " isn't a static method");
        }
        return staticHandler;
    }

    private static Supplier<ClassDesc> convert(Supplier<Class<?>> classSupplier) {
        return () -> ((Class)classSupplier.get()).describeConstable().orElseThrow();
    }

    @Override
    public RewriteRule build() {
        if (this.rules.size() == 1) {
            return this.rules.get(0);
        }
        return RewriteRule.chain(this.rules);
    }
}

