/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.impl.restrict;

import io.mockk.MockKException;
import io.mockk.impl.log.Logger;
import io.mockk.impl.restrict.MockkValidator;
import io.mockk.impl.restrict.RestrictMockkConfiguration;
import java.util.Collection;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0002J\u0012\u0010\u0012\u001a\u00020\u00132\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/mockk/impl/restrict/MockkValidator;", "", "configuration", "Lio/mockk/impl/restrict/RestrictMockkConfiguration;", "(Lio/mockk/impl/restrict/RestrictMockkConfiguration;)V", "logger", "Lio/mockk/impl/log/Logger;", "getLogger", "()Lio/mockk/impl/log/Logger;", "logger$delegate", "Lkotlin/Lazy;", "restrictedClasses", "", "", "isRestrictedClass", "", "clazz", "Lkotlin/reflect/KClass;", "validateMockableClass", "", "mockk"})
@SourceDebugExtension(value={"SMAP\nMockkValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MockkValidator.kt\nio/mockk/impl/restrict/MockkValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,36:1\n1755#2,3:37\n*S KotlinDebug\n*F\n+ 1 MockkValidator.kt\nio/mockk/impl/restrict/MockkValidator\n*L\n26#1:37,3\n*E\n"})
public final class MockkValidator {
    @NotNull
    private final RestrictMockkConfiguration configuration;
    @NotNull
    private final Lazy logger$delegate;
    @NotNull
    private final Set<String> restrictedClasses;

    public MockkValidator(@NotNull RestrictMockkConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.configuration = configuration;
        this.logger$delegate = LazyKt.lazy((Function0)logger.2.INSTANCE);
        this.restrictedClasses = this.configuration.getRestrictedTypes();
    }

    private final Logger getLogger() {
        Lazy lazy = this.logger$delegate;
        return (Logger)lazy.getValue();
    }

    public final void validateMockableClass(@NotNull KClass<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        if (this.isRestrictedClass(clazz)) {
            this.getLogger().warn((Function0<String>)((Function0)new Function0<String>(clazz){
                final /* synthetic */ KClass<?> $clazz;
                {
                    this.$clazz = $clazz;
                    super(0);
                }

                public final String invoke() {
                    return this.$clazz.getSimpleName() + " should not be mocked! Consider refactoring your test.";
                }
            }));
            if (this.configuration.getThrowExceptionOnBadMock()) {
                throw new MockKException("Mocking " + clazz.getQualifiedName() + " is not allowed!", null, 2, null);
            }
        }
    }

    private final boolean isRestrictedClass(KClass<?> clazz) {
        boolean bl;
        block7: {
            String string = clazz.getQualifiedName();
            if (string == null) {
                return false;
            }
            String className = string;
            if (this.restrictedClasses.contains(className)) {
                return true;
            }
            Iterable $this$any$iv = this.restrictedClasses;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    String restricted = (String)element$iv;
                    boolean bl3 = false;
                    try {
                        Class<?> restrictedClass = Class.forName(restricted);
                        bl2 = restrictedClass.isAssignableFrom(JvmClassMappingKt.getJavaClass(clazz));
                    }
                    catch (ClassNotFoundException e) {
                        bl2 = false;
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }
}

