/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.micrometer;

import io.javalin.config.JavalinConfig;
import io.javalin.http.Context;
import io.javalin.http.ExceptionHandler;
import io.javalin.http.HandlerType;
import io.javalin.http.HttpStatus;
import io.javalin.micrometer.MicrometerPlugin;
import io.javalin.micrometer.MicrometerPluginConfig;
import io.javalin.plugin.Plugin;
import io.javalin.router.InternalRouter;
import io.javalin.util.Util;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.http.DefaultHttpJakartaServletRequestTagsProvider;
import io.micrometer.core.instrument.binder.http.HttpJakartaServletRequestTagsProvider;
import io.micrometer.core.instrument.binder.jetty.JettyConnectionMetrics;
import io.micrometer.core.instrument.binder.jetty.JettyServerThreadPoolMetrics;
import io.micrometer.jetty11.TimedHandler;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.function.Consumer;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\fB\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\bH\u0016J\u0014\u0010\t\u001a\u00020\n*\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a8\u0006\r"}, d2={"Lio/javalin/micrometer/MicrometerPlugin;", "Lio/javalin/plugin/Plugin;", "Lio/javalin/micrometer/MicrometerPluginConfig;", "config", "Ljava/util/function/Consumer;", "(Ljava/util/function/Consumer;)V", "onStart", "", "Lio/javalin/config/JavalinConfig;", "prefixIfNot", "", "prefix", "Companion", "javalin-micrometer"})
@SourceDebugExtension(value={"SMAP\nMicrometerPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MicrometerPlugin.kt\nio/javalin/micrometer/MicrometerPlugin\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n1#2:93\n*E\n"})
public final class MicrometerPlugin
extends Plugin<MicrometerPluginConfig> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String EXCEPTION_HEADER = "__micrometer_exception_name";
    @JvmField
    @NotNull
    public static ExceptionHandler<Exception> exceptionHandler = MicrometerPlugin::exceptionHandler$lambda$3;

    public MicrometerPlugin(@NotNull Consumer<MicrometerPluginConfig> config) {
        Intrinsics.checkNotNullParameter(config, (String)"config");
        super(config, (Object)new MicrometerPluginConfig());
    }

    public void onStart(@NotNull JavalinConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        InternalRouter internalRouter = config.pvt.internalRouter;
        if (((MicrometerPluginConfig)this.pluginConfig).tagExceptionName) {
            internalRouter.addHttpExceptionHandler(Exception.class, exceptionHandler);
        }
        config.jetty.modifyServer(arg_0 -> MicrometerPlugin.onStart$lambda$1(this, config, internalRouter, arg_0));
    }

    private final String prefixIfNot(String $this$prefixIfNot, String prefix) {
        return StringsKt.startsWith$default((String)$this$prefixIfNot, (String)prefix, (boolean)false, (int)2, null) ? $this$prefixIfNot : prefix + $this$prefixIfNot;
    }

    private static final void onStart$lambda$1$lambda$0(Server $server, MicrometerPlugin this$0) {
        Intrinsics.checkNotNullParameter((Object)$server, (String)"$server");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        JettyConnectionMetrics.addToAllConnectors((Server)$server, (MeterRegistry)((MicrometerPluginConfig)this$0.pluginConfig).registry, ((MicrometerPluginConfig)this$0.pluginConfig).tags);
    }

    private static final void onStart$lambda$1(MicrometerPlugin this$0, JavalinConfig $config, InternalRouter $internalRouter, Server server) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$config, (String)"$config");
        Intrinsics.checkNotNullParameter((Object)$internalRouter, (String)"$internalRouter");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        server.insertHandler((HandlerWrapper)new TimedHandler(((MicrometerPluginConfig)this$0.pluginConfig).registry, ((MicrometerPluginConfig)this$0.pluginConfig).tags, (HttpJakartaServletRequestTagsProvider)new DefaultHttpJakartaServletRequestTagsProvider(this$0, $config, $internalRouter){
            final /* synthetic */ MicrometerPlugin this$0;
            final /* synthetic */ JavalinConfig $config;
            final /* synthetic */ InternalRouter $internalRouter;
            {
                this.this$0 = $receiver;
                this.$config = $config;
                this.$internalRouter = $internalRouter;
            }

            @NotNull
            public Iterable<Tag> getTags(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                String exceptionName = ((MicrometerPluginConfig)MicrometerPlugin.access$getPluginConfig$p((MicrometerPlugin)this.this$0)).tagExceptionName ? response.getHeader("__micrometer_exception_name") : "Unknown";
                String string = request.getPathInfo();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPathInfo(...)");
                String pathInfo = MicrometerPlugin.access$prefixIfNot(this.this$0, StringsKt.removePrefix((String)string, (CharSequence)this.$config.router.contextPath), "/");
                response.setHeader("__micrometer_exception_name", null);
                String string2 = request.getMethod();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMethod(...)");
                HandlerType handlerType = HandlerType.valueOf((String)string2);
                Stream<String> stream = this.$internalRouter.findHttpHandlerEntries(handlerType, pathInfo).map(arg_0 -> onStart.1.1.getTags$lambda$0(onStart.1.getTags.uri.1.INSTANCE, arg_0)).map(arg_0 -> onStart.1.1.getTags$lambda$1(onStart.1.getTags.uri.2.INSTANCE, arg_0)).map(arg_0 -> onStart.1.1.getTags$lambda$2((Function1)new Function1<String, String>(this.this$0, response){
                    final /* synthetic */ MicrometerPlugin this$0;
                    final /* synthetic */ HttpServletResponse $response;
                    {
                        this.this$0 = $receiver;
                        this.$response = $response;
                        super(1);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final String invoke(String it) {
                        if (!((MicrometerPluginConfig)MicrometerPlugin.access$getPluginConfig$p((MicrometerPlugin)this.this$0)).tagRedirectPaths) {
                            boolean bl;
                            int n = this.$response.getStatus();
                            if (300 <= n) {
                                if (n < 400) {
                                    return "REDIRECTION";
                                }
                                bl = false;
                            } else {
                                bl = false;
                            }
                            if (bl) {
                                return "REDIRECTION";
                            }
                        }
                        String string = it;
                        return string;
                    }
                }, arg_0)).map(arg_0 -> onStart.1.1.getTags$lambda$3((Function1)new Function1<String, String>(this.this$0, response){
                    final /* synthetic */ MicrometerPlugin this$0;
                    final /* synthetic */ HttpServletResponse $response;
                    {
                        this.this$0 = $receiver;
                        this.$response = $response;
                        super(1);
                    }

                    public final String invoke(String it) {
                        return !((MicrometerPluginConfig)MicrometerPlugin.access$getPluginConfig$p((MicrometerPlugin)this.this$0)).tagNotFoundMappedPaths && this.$response.getStatus() == 404 ? "NOT_FOUND" : it;
                    }
                }, arg_0));
                Intrinsics.checkNotNullExpressionValue(stream, (String)"map(...)");
                String string3 = (String)Util.INSTANCE.firstOrNull(stream);
                if (string3 == null) {
                    string3 = "NOT_FOUND";
                }
                String uri2 = string3;
                Iterable iterable = super.getTags(request, response);
                String[] stringArray = new String[4];
                stringArray[0] = "uri";
                stringArray[1] = uri2;
                stringArray[2] = "exception";
                String string4 = exceptionName;
                if (string4 == null) {
                    string4 = "None";
                }
                stringArray[3] = string4;
                Tags tags = Tags.concat((Iterable)iterable, (String[])stringArray);
                Intrinsics.checkNotNullExpressionValue((Object)tags, (String)"concat(...)");
                return (Iterable)tags;
            }

            private static final String getTags$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (String)$tmp0.invoke(p0);
            }

            private static final String getTags$lambda$1(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (String)$tmp0.invoke(p0);
            }

            private static final String getTags$lambda$2(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (String)$tmp0.invoke(p0);
            }

            private static final String getTags$lambda$3(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (String)$tmp0.invoke(p0);
            }
        }));
        new JettyServerThreadPoolMetrics(server.getThreadPool(), ((MicrometerPluginConfig)this$0.pluginConfig).tags).bindTo(((MicrometerPluginConfig)this$0.pluginConfig).registry);
        $config.events.serverStarted(() -> MicrometerPlugin.onStart$lambda$1$lambda$0(server, this$0));
    }

    private static final void exceptionHandler$lambda$3(Exception e, Context ctx) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        String simpleName = e.getClass().getSimpleName();
        Context context = ctx;
        String string = EXCEPTION_HEADER;
        CharSequence charSequence2 = simpleName;
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            String string2 = string;
            Context context2 = context;
            boolean bl = false;
            String string3 = e.getClass().getName();
            context = context2;
            string = string2;
            charSequence = string3;
        } else {
            charSequence = charSequence2;
        }
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"ifBlank(...)");
        context.header(string, (String)charSequence);
        ctx.status(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    public static final /* synthetic */ Object access$getPluginConfig$p(MicrometerPlugin $this) {
        return $this.pluginConfig;
    }

    public static final /* synthetic */ String access$prefixIfNot(MicrometerPlugin $this, String $receiver, String prefix) {
        return $this.prefixIfNot($receiver, prefix);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/javalin/micrometer/MicrometerPlugin$Companion;", "", "()V", "EXCEPTION_HEADER", "", "exceptionHandler", "Lio/javalin/http/ExceptionHandler;", "Ljava/lang/Exception;", "kotlin.jvm.PlatformType", "javalin-micrometer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

