/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.community.ssl.util;

import io.javalin.community.ssl.SslConfig;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/javalin/community/ssl/util/ConnectorFactory;", "", "config", "Lio/javalin/community/ssl/SslConfig;", "sslContextFactory", "Lorg/eclipse/jetty/util/ssl/SslContextFactory$Server;", "(Lio/javalin/community/ssl/SslConfig;Lorg/eclipse/jetty/util/ssl/SslContextFactory$Server;)V", "createInsecureConnector", "Lorg/eclipse/jetty/server/ServerConnector;", "server", "Lorg/eclipse/jetty/server/Server;", "httpConfiguration", "Lorg/eclipse/jetty/server/HttpConfiguration;", "createSecureConnector", "ssl-plugin"})
@SourceDebugExtension(value={"SMAP\nConnectorFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectorFactory.kt\nio/javalin/community/ssl/util/ConnectorFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
public final class ConnectorFactory {
    @NotNull
    private SslConfig config;
    @Nullable
    private SslContextFactory.Server sslContextFactory;

    public ConnectorFactory(@NotNull SslConfig config, @Nullable SslContextFactory.Server sslContextFactory) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.sslContextFactory = sslContextFactory;
    }

    @NotNull
    public final ServerConnector createInsecureConnector(@Nullable Server server, @NotNull HttpConfiguration httpConfiguration) {
        ServerConnector connector;
        block4: {
            ServerConnector serverConnector;
            Intrinsics.checkNotNullParameter((Object)httpConfiguration, (String)"httpConfiguration");
            connector = null;
            if (this.config.secure) {
                httpConfiguration.setSecurePort(this.config.securePort);
            }
            HttpConnectionFactory http11 = new HttpConnectionFactory(httpConfiguration);
            if (this.config.http2) {
                HTTP2CServerConnectionFactory http2 = new HTTP2CServerConnectionFactory(httpConfiguration);
                ConnectionFactory[] connectionFactoryArray = new ConnectionFactory[]{http11, http2};
                ServerConnector serverConnector2 = new ServerConnector(server, connectionFactoryArray);
                serverConnector = serverConnector2;
            } else {
                ConnectionFactory[] connectionFactoryArray = new ConnectionFactory[]{http11};
                ServerConnector serverConnector3 = new ServerConnector(server, connectionFactoryArray);
                serverConnector = serverConnector3;
            }
            connector = serverConnector;
            connector.setPort(this.config.insecurePort);
            String string = this.config.host;
            if (string != null) {
                String it = string;
                boolean bl = false;
                connector.setHost(it);
            }
            Consumer<ServerConnector> consumer = this.config.getConfigConnectors();
            if (consumer == null) break block4;
            consumer.accept(connector);
        }
        return connector;
    }

    @NotNull
    public final ServerConnector createSecureConnector(@Nullable Server server, @NotNull HttpConfiguration httpConfiguration) {
        ServerConnector connector;
        block3: {
            ServerConnector serverConnector;
            Intrinsics.checkNotNullParameter((Object)httpConfiguration, (String)"httpConfiguration");
            connector = null;
            httpConfiguration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer(this.config.sniHostCheck));
            HttpConnectionFactory http11 = new HttpConnectionFactory(httpConfiguration);
            if (this.config.http2) {
                HTTP2ServerConnectionFactory http2 = new HTTP2ServerConnectionFactory(httpConfiguration);
                ALPNServerConnectionFactory alpn = new ALPNServerConnectionFactory(new String[0]);
                alpn.setDefaultProtocol(http11.getProtocol());
                SslConnectionFactory tlsHttp2 = new SslConnectionFactory(this.sslContextFactory, alpn.getProtocol());
                ConnectionFactory[] connectionFactoryArray = new ConnectionFactory[]{tlsHttp2, alpn, http2, http11};
                ServerConnector serverConnector2 = new ServerConnector(server, connectionFactoryArray);
                serverConnector = serverConnector2;
            } else {
                SslConnectionFactory tls = new SslConnectionFactory(this.sslContextFactory, http11.getProtocol());
                ConnectionFactory[] connectionFactoryArray = new ConnectionFactory[]{tls, http11};
                ServerConnector serverConnector3 = new ServerConnector(server, connectionFactoryArray);
                serverConnector = serverConnector3;
            }
            connector = serverConnector;
            connector.setPort(this.config.securePort);
            String string = this.config.host;
            if (string != null) {
                String it = string;
                boolean bl = false;
                connector.setHost(it);
            }
            Consumer<ServerConnector> consumer = this.config.getConfigConnectors();
            if (consumer == null) break block3;
            consumer.accept(connector);
        }
        return connector;
    }
}

