/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.dialog;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import lombok.Generated;
import net.md_5.bungee.api.dialog.ConfirmationDialog;
import net.md_5.bungee.api.dialog.Dialog;
import net.md_5.bungee.api.dialog.DialogBase;
import net.md_5.bungee.api.dialog.DialogListDialog;
import net.md_5.bungee.api.dialog.MultiActionDialog;
import net.md_5.bungee.api.dialog.MultiActionInputFormDialog;
import net.md_5.bungee.api.dialog.NoticeDialog;
import net.md_5.bungee.api.dialog.ServerLinksDialog;
import net.md_5.bungee.api.dialog.SimpleInputFormDialog;
import net.md_5.bungee.chat.VersionedComponentSerializer;

public class DialogSerializer
implements JsonDeserializer<Dialog>,
JsonSerializer<Dialog> {
    private static final BiMap<String, Class<? extends Dialog>> TYPES;
    private final VersionedComponentSerializer serializer;

    public JsonElement toJson(Dialog dialog) {
        return this.serializer.getGson().toJsonTree((Object)dialog, Dialog.class);
    }

    public String toString(Dialog dialog) {
        return this.serializer.getGson().toJson((Object)dialog, Dialog.class);
    }

    public Dialog deserialize(JsonElement jsonElement) {
        return (Dialog)this.serializer.getGson().fromJson(jsonElement, Dialog.class);
    }

    public Dialog deserialize(String json) {
        JsonElement jsonElement = JsonParser.parseString((String)json);
        return this.deserialize(jsonElement);
    }

    public Dialog deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        String type = object.get("type").getAsString();
        if (object.has("base")) {
            throw new JsonParseException("Cannot explicitly specify base");
        }
        Type realType = (Type)TYPES.get((Object)type);
        if (realType == null) {
            throw new JsonParseException("Unknown type " + type);
        }
        Dialog dialog = (Dialog)context.deserialize(json, realType);
        DialogBase base = (DialogBase)context.deserialize(json, DialogBase.class);
        dialog.setBase(base);
        return dialog;
    }

    public JsonElement serialize(Dialog src, Type typeOfSrc, JsonSerializationContext context) {
        if (src == null) {
            return JsonNull.INSTANCE;
        }
        Class realType = src.getClass();
        String type = (String)TYPES.inverse().get((Object)realType);
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Unknown type %s", (Object)typeOfSrc);
        JsonObject object = (JsonObject)context.serialize((Object)src, (Type)realType);
        object.addProperty("type", type);
        JsonObject base = (JsonObject)context.serialize((Object)src.getBase());
        object.asMap().putAll(base.asMap());
        return object;
    }

    @Generated
    public DialogSerializer(VersionedComponentSerializer serializer) {
        this.serializer = serializer;
    }

    static {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        builder.put((Object)"minecraft:notice", NoticeDialog.class);
        builder.put((Object)"minecraft:confirmation", ConfirmationDialog.class);
        builder.put((Object)"minecraft:multi_action", MultiActionDialog.class);
        builder.put((Object)"minecraft:server_links", ServerLinksDialog.class);
        builder.put((Object)"minecraft:dialog_list", DialogListDialog.class);
        builder.put((Object)"minecraft:simple_input_form", SimpleInputFormDialog.class);
        builder.put((Object)"minecraft:multi_action_input_form", MultiActionInputFormDialog.class);
        TYPES = builder.build();
    }
}

