/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.Either;
import net.md_5.bungee.protocol.ProtocolConstants;

public class ServerLinks
extends DefinedPacket {
    private Link[] links;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        int len = ServerLinks.readVarInt(buf);
        this.links = new Link[len];
        for (int i = 0; i < len; ++i) {
            Either<Object, Object> type = buf.readBoolean() ? Either.left(LinkType.values()[ServerLinks.readVarInt(buf)]) : Either.right(ServerLinks.readBaseComponent(buf, protocolVersion));
            String url = ServerLinks.readString(buf);
            this.links[i] = new Link(type, url);
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        ServerLinks.writeVarInt(this.links.length, buf);
        for (Link link : this.links) {
            Either<LinkType, BaseComponent> type = link.getType();
            if (type.isLeft()) {
                buf.writeBoolean(true);
                ServerLinks.writeVarInt(type.getLeft().ordinal(), buf);
            } else {
                buf.writeBoolean(false);
                ServerLinks.writeBaseComponent(type.getRight(), buf, protocolVersion);
            }
            ServerLinks.writeString(link.getUrl(), buf);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public Link[] getLinks() {
        return this.links;
    }

    public void setLinks(Link[] links) {
        this.links = links;
    }

    @Override
    public String toString() {
        return "ServerLinks(links=" + Arrays.deepToString(this.getLinks()) + ")";
    }

    public ServerLinks() {
    }

    public ServerLinks(Link[] links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerLinks)) {
            return false;
        }
        ServerLinks other = (ServerLinks)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.deepEquals(this.getLinks(), other.getLinks());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerLinks;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getLinks());
        return result;
    }

    public static class Link {
        private final Either<LinkType, BaseComponent> type;
        private final String url;

        public Link(Either<LinkType, BaseComponent> type, String url) {
            this.type = type;
            this.url = url;
        }

        public Either<LinkType, BaseComponent> getType() {
            return this.type;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Link)) {
                return false;
            }
            Link other = (Link)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Either<LinkType, BaseComponent> this$type = this.getType();
            Either<LinkType, BaseComponent> other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Link;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Either<LinkType, BaseComponent> $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }

        public String toString() {
            return "ServerLinks.Link(type=" + this.getType() + ", url=" + this.getUrl() + ")";
        }
    }

    public static enum LinkType {
        REPORT_BUG,
        COMMUNITY_GUIDELINES,
        SUPPORT,
        STATUS,
        FEEDBACK,
        COMMUNITY,
        WEBSITE,
        FORUMS,
        NEWS,
        ANNOUNCEMENTS;

    }
}

