/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.BadPacketException;
import net.md_5.bungee.protocol.MinecraftDecoder;
import net.md_5.bungee.protocol.OverflowPacketException;
import net.md_5.bungee.protocol.PlayerPublicKey;
import net.md_5.bungee.protocol.Property;
import net.md_5.bungee.protocol.ProtocolConstants;
import se.llbit.nbt.NamedTag;
import se.llbit.nbt.Tag;

public abstract class DefinedPacket {
    private static final boolean PROCESS_TRACES = Boolean.getBoolean("waterfall.bad-packet-traces");
    private static final BadPacketException OVERSIZED_VAR_INT_EXCEPTION = new BadPacketException("VarInt too big");
    private static final BadPacketException NO_MORE_BYTES_EXCEPTION = new BadPacketException("No more bytes reading varint");
    private static final OverflowPacketException STRING_TOO_LONG_EXCEPTION = new OverflowPacketException("A string was longer than allowed. For more information, launch Waterfall with -Dwaterfall.packet-decode-logging=true");
    private static final OverflowPacketException STRING_TOO_MANY_BYTES_EXCEPTION = new OverflowPacketException("A string had more data than allowed. For more information, launch Waterfall with -Dwaterfall.packet-decode-logging=true");

    public static void writeString(String s, ByteBuf buf) {
        DefinedPacket.writeString(s, buf, Short.MAX_VALUE);
    }

    public static void writeString(String s, ByteBuf buf, int maxLength) {
        if (s.length() > maxLength) {
            throw new OverflowPacketException("Cannot send string longer than " + maxLength + " (got " + s.length() + " characters)");
        }
        byte[] b = s.getBytes(Charsets.UTF_8);
        if (b.length > maxLength * 3) {
            throw new OverflowPacketException("Cannot send string longer than " + maxLength * 3 + " (got " + b.length + " bytes)");
        }
        DefinedPacket.writeVarInt(b.length, buf);
        buf.writeBytes(b);
    }

    public static String readString(ByteBuf buf) {
        return DefinedPacket.readString(buf, Short.MAX_VALUE);
    }

    public static String readString(ByteBuf buf, int maxLen) {
        int len = DefinedPacket.readVarInt(buf);
        if (len > maxLen * 3) {
            if (!MinecraftDecoder.DEBUG) {
                throw STRING_TOO_MANY_BYTES_EXCEPTION;
            }
            throw new OverflowPacketException("Cannot receive string longer than " + maxLen * 3 + " (got " + len + " bytes)");
        }
        String s = buf.toString(buf.readerIndex(), len, Charsets.UTF_8);
        buf.readerIndex(buf.readerIndex() + len);
        if (s.length() > maxLen) {
            if (!MinecraftDecoder.DEBUG) {
                throw STRING_TOO_LONG_EXCEPTION;
            }
            throw new OverflowPacketException("Cannot receive string longer than " + maxLen + " (got " + s.length() + " characters)");
        }
        return s;
    }

    public static void writeArray(byte[] b, ByteBuf buf) {
        if (b.length > Short.MAX_VALUE) {
            throw new OverflowPacketException("Cannot send byte array longer than Short.MAX_VALUE (got " + b.length + " bytes)");
        }
        DefinedPacket.writeVarInt(b.length, buf);
        buf.writeBytes(b);
    }

    public static byte[] toArray(ByteBuf buf) {
        byte[] ret = new byte[buf.readableBytes()];
        buf.readBytes(ret);
        return ret;
    }

    public static byte[] readArray(ByteBuf buf) {
        return DefinedPacket.readArray(buf, buf.readableBytes());
    }

    public static byte[] readArray(ByteBuf buf, int limit) {
        int len = DefinedPacket.readVarInt(buf);
        if (len > limit) {
            throw new OverflowPacketException("Cannot receive byte array longer than " + limit + " (got " + len + " bytes)");
        }
        byte[] ret = new byte[len];
        buf.readBytes(ret);
        return ret;
    }

    public static int[] readVarIntArray(ByteBuf buf) {
        int len = DefinedPacket.readVarInt(buf);
        int[] ret = new int[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = DefinedPacket.readVarInt(buf);
        }
        return ret;
    }

    public static void writeStringArray(List<String> s, ByteBuf buf) {
        DefinedPacket.writeVarInt(s.size(), buf);
        for (String str : s) {
            DefinedPacket.writeString(str, buf);
        }
    }

    public static List<String> readStringArray(ByteBuf buf) {
        int len = DefinedPacket.readVarInt(buf);
        ArrayList<String> ret = new ArrayList<String>(len);
        for (int i = 0; i < len; ++i) {
            ret.add(DefinedPacket.readString(buf));
        }
        return ret;
    }

    public static int readVarInt(ByteBuf input) {
        return DefinedPacket.readVarInt(input, 5);
    }

    public static int readVarInt(ByteBuf input, int maxBytes) {
        byte in;
        int out = 0;
        int bytes = 0;
        do {
            if (input.readableBytes() == 0) {
                throw PROCESS_TRACES ? new BadPacketException("No more bytes reading varint") : NO_MORE_BYTES_EXCEPTION;
            }
            in = input.readByte();
            out |= (in & 0x7F) << bytes++ * 7;
            if (bytes <= maxBytes) continue;
            throw PROCESS_TRACES ? new BadPacketException("VarInt too big") : OVERSIZED_VAR_INT_EXCEPTION;
        } while ((in & 0x80) == 128);
        return out;
    }

    public static void writeVarInt(int value, ByteBuf output) {
        do {
            int part = value & 0x7F;
            if ((value >>>= 7) != 0) {
                part |= 0x80;
            }
            output.writeByte(part);
        } while (value != 0);
    }

    public static int readVarShort(ByteBuf buf) {
        int low = buf.readUnsignedShort();
        int high = 0;
        if ((low & 0x8000) != 0) {
            low &= Short.MAX_VALUE;
            high = buf.readUnsignedByte();
        }
        return (high & 0xFF) << 15 | low;
    }

    public static void writeVarShort(ByteBuf buf, int toWrite) {
        int low = toWrite & Short.MAX_VALUE;
        int high = (toWrite & 0x7F8000) >> 15;
        if (high != 0) {
            low |= 0x8000;
        }
        buf.writeShort(low);
        if (high != 0) {
            buf.writeByte(high);
        }
    }

    public static void writeUUID(UUID value, ByteBuf output) {
        output.writeLong(value.getMostSignificantBits());
        output.writeLong(value.getLeastSignificantBits());
    }

    public static UUID readUUID(ByteBuf input) {
        return new UUID(input.readLong(), input.readLong());
    }

    public static void writeProperties(Property[] properties, ByteBuf buf) {
        if (properties == null) {
            DefinedPacket.writeVarInt(0, buf);
            return;
        }
        DefinedPacket.writeVarInt(properties.length, buf);
        for (Property prop : properties) {
            DefinedPacket.writeString(prop.getName(), buf);
            DefinedPacket.writeString(prop.getValue(), buf);
            if (prop.getSignature() != null) {
                buf.writeBoolean(true);
                DefinedPacket.writeString(prop.getSignature(), buf);
                continue;
            }
            buf.writeBoolean(false);
        }
    }

    public static Property[] readProperties(ByteBuf buf) {
        Property[] properties = new Property[DefinedPacket.readVarInt(buf)];
        for (int j = 0; j < properties.length; ++j) {
            String name = DefinedPacket.readString(buf);
            String value = DefinedPacket.readString(buf);
            properties[j] = buf.readBoolean() ? new Property(name, value, DefinedPacket.readString(buf)) : new Property(name, value);
        }
        return properties;
    }

    public static void writePublicKey(PlayerPublicKey publicKey, ByteBuf buf) {
        if (publicKey != null) {
            buf.writeBoolean(true);
            buf.writeLong(publicKey.getExpiry());
            DefinedPacket.writeArray(publicKey.getKey(), buf);
            DefinedPacket.writeArray(publicKey.getSignature(), buf);
        } else {
            buf.writeBoolean(false);
        }
    }

    public static PlayerPublicKey readPublicKey(ByteBuf buf) {
        if (buf.readBoolean()) {
            return new PlayerPublicKey(buf.readLong(), DefinedPacket.readArray(buf, 512), DefinedPacket.readArray(buf, 4096));
        }
        return null;
    }

    public static Tag readTag(ByteBuf input) {
        Tag tag = NamedTag.read((DataInputStream)new DataInputStream((InputStream)new ByteBufInputStream(input)));
        Preconditions.checkArgument((!tag.isError() ? 1 : 0) != 0, (String)"Error reading tag: %s", (Object)tag.error());
        return tag;
    }

    public static void writeTag(Tag tag, ByteBuf output) {
        try {
            tag.write(new DataOutputStream((OutputStream)new ByteBufOutputStream(output)));
        }
        catch (IOException ex) {
            throw new RuntimeException("Exception writing tag", ex);
        }
    }

    public void read(ByteBuf buf) {
        throw new UnsupportedOperationException("Packet must implement read method");
    }

    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.read(buf);
    }

    public void write(ByteBuf buf) {
        throw new UnsupportedOperationException("Packet must implement write method");
    }

    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.write(buf);
    }

    public abstract void handle(AbstractPacketHandler var1) throws Exception;

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    public int expectedMaxLength(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        return -1;
    }

    public int expectedMinLength(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        return 0;
    }
}

