/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.PlayerPublicKey;
import net.md_5.bungee.protocol.ProtocolConstants;

public class LoginRequest
extends DefinedPacket {
    private String data;
    private PlayerPublicKey publicKey;
    private UUID uuid;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.data = LoginRequest.readString(buf, 16);
        if (protocolVersion >= 759) {
            this.publicKey = LoginRequest.readPublicKey(buf);
        }
        if (protocolVersion >= 760 && buf.readBoolean()) {
            this.uuid = LoginRequest.readUUID(buf);
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        LoginRequest.writeString(this.data, buf);
        if (protocolVersion >= 759) {
            LoginRequest.writePublicKey(this.publicKey, buf);
        }
        if (protocolVersion >= 760) {
            if (this.uuid != null) {
                buf.writeBoolean(true);
                LoginRequest.writeUUID(this.uuid, buf);
            } else {
                buf.writeBoolean(false);
            }
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    @Override
    public int expectedMaxLength(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (protocolVersion >= 759) {
            return -1;
        }
        return 65;
    }

    public String getData() {
        return this.data;
    }

    public PlayerPublicKey getPublicKey() {
        return this.publicKey;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setPublicKey(PlayerPublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    @Override
    public String toString() {
        return "LoginRequest(data=" + this.getData() + ", publicKey=" + this.getPublicKey() + ", uuid=" + this.getUuid() + ")";
    }

    public LoginRequest() {
    }

    public LoginRequest(String data, PlayerPublicKey publicKey, UUID uuid) {
        this.data = data;
        this.publicKey = publicKey;
        this.uuid = uuid;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoginRequest)) {
            return false;
        }
        LoginRequest other = (LoginRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        PlayerPublicKey this$publicKey = this.getPublicKey();
        PlayerPublicKey other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !((Object)this$publicKey).equals(other$publicKey)) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        return !(this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LoginRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        PlayerPublicKey $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : ((Object)$publicKey).hashCode());
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        return result;
    }
}

