/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Arrays;
import java.util.function.Supplier;
import net.md_5.bungee.protocol.BadPacketException;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.packet.BossBar;
import net.md_5.bungee.protocol.packet.Chat;
import net.md_5.bungee.protocol.packet.ClearTitles;
import net.md_5.bungee.protocol.packet.ClientChat;
import net.md_5.bungee.protocol.packet.ClientCommand;
import net.md_5.bungee.protocol.packet.ClientSettings;
import net.md_5.bungee.protocol.packet.Commands;
import net.md_5.bungee.protocol.packet.EncryptionRequest;
import net.md_5.bungee.protocol.packet.EncryptionResponse;
import net.md_5.bungee.protocol.packet.EntityEffect;
import net.md_5.bungee.protocol.packet.EntityRemoveEffect;
import net.md_5.bungee.protocol.packet.EntityStatus;
import net.md_5.bungee.protocol.packet.GameState;
import net.md_5.bungee.protocol.packet.Handshake;
import net.md_5.bungee.protocol.packet.KeepAlive;
import net.md_5.bungee.protocol.packet.Kick;
import net.md_5.bungee.protocol.packet.Login;
import net.md_5.bungee.protocol.packet.LoginPayloadRequest;
import net.md_5.bungee.protocol.packet.LoginPayloadResponse;
import net.md_5.bungee.protocol.packet.LoginRequest;
import net.md_5.bungee.protocol.packet.LoginSuccess;
import net.md_5.bungee.protocol.packet.PingPacket;
import net.md_5.bungee.protocol.packet.PlayerListHeaderFooter;
import net.md_5.bungee.protocol.packet.PlayerListItem;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.protocol.packet.Respawn;
import net.md_5.bungee.protocol.packet.ScoreboardDisplay;
import net.md_5.bungee.protocol.packet.ScoreboardObjective;
import net.md_5.bungee.protocol.packet.ScoreboardScore;
import net.md_5.bungee.protocol.packet.SetCompression;
import net.md_5.bungee.protocol.packet.StatusRequest;
import net.md_5.bungee.protocol.packet.StatusResponse;
import net.md_5.bungee.protocol.packet.Subtitle;
import net.md_5.bungee.protocol.packet.SystemChat;
import net.md_5.bungee.protocol.packet.TabCompleteRequest;
import net.md_5.bungee.protocol.packet.TabCompleteResponse;
import net.md_5.bungee.protocol.packet.Team;
import net.md_5.bungee.protocol.packet.Title;
import net.md_5.bungee.protocol.packet.TitleTimes;
import net.md_5.bungee.protocol.packet.ViewDistance;

public enum Protocol {
    HANDSHAKE{
        {
            this.TO_SERVER.registerPacket(Handshake.class, Handshake::new, new ProtocolMapping[]{Protocol.map(47, 0)});
        }
    }
    ,
    GAME{
        {
            this.TO_CLIENT.registerPacket(KeepAlive.class, KeepAlive::new, new ProtocolMapping[]{Protocol.map(47, 0), Protocol.map(107, 31), Protocol.map(393, 33), Protocol.map(477, 32), Protocol.map(573, 33), Protocol.map(735, 32), Protocol.map(751, 31), Protocol.map(755, 33), Protocol.map(759, 30), Protocol.map(760, 32)});
            this.TO_CLIENT.registerPacket(Login.class, Login::new, new ProtocolMapping[]{Protocol.map(47, 1), Protocol.map(107, 35), Protocol.map(393, 37), Protocol.map(573, 38), Protocol.map(735, 37), Protocol.map(751, 36), Protocol.map(755, 38), Protocol.map(759, 35), Protocol.map(760, 37)});
            this.TO_CLIENT.registerPacket(Chat.class, Chat::new, new ProtocolMapping[]{Protocol.map(47, 2), Protocol.map(107, 15), Protocol.map(393, 14), Protocol.map(573, 15), Protocol.map(735, 14), Protocol.map(755, 15), Protocol.map(759, -1)});
            this.TO_CLIENT.registerPacket(Respawn.class, Respawn::new, new ProtocolMapping[]{Protocol.map(47, 7), Protocol.map(107, 51), Protocol.map(335, 52), Protocol.map(338, 53), Protocol.map(393, 56), Protocol.map(477, 58), Protocol.map(573, 59), Protocol.map(735, 58), Protocol.map(751, 57), Protocol.map(755, 61), Protocol.map(759, 59), Protocol.map(760, 62)});
            this.TO_CLIENT.registerPacket(BossBar.class, BossBar::new, new ProtocolMapping[]{Protocol.map(107, 12), Protocol.map(573, 13), Protocol.map(735, 12), Protocol.map(755, 13), Protocol.map(759, 10)});
            this.TO_CLIENT.registerPacket(EntityEffect.class, EntityEffect::new, new ProtocolMapping[]{Protocol.map(47, 29), Protocol.map(107, -1)});
            this.TO_CLIENT.registerPacket(EntityRemoveEffect.class, EntityRemoveEffect::new, new ProtocolMapping[]{Protocol.map(47, 30), Protocol.map(107, -1)});
            this.TO_CLIENT.registerPacket(PlayerListItem.class, PlayerListItem::new, new ProtocolMapping[]{Protocol.map(47, 56), Protocol.map(107, 45), Protocol.map(338, 46), Protocol.map(393, 48), Protocol.map(477, 51), Protocol.map(573, 52), Protocol.map(735, 51), Protocol.map(751, 50), Protocol.map(755, 54), Protocol.map(759, 52), Protocol.map(760, 55)});
            this.TO_CLIENT.registerPacket(TabCompleteResponse.class, TabCompleteResponse::new, new ProtocolMapping[]{Protocol.map(47, 58), Protocol.map(107, 14), Protocol.map(393, 16), Protocol.map(573, 17), Protocol.map(735, 16), Protocol.map(751, 15), Protocol.map(755, 17), Protocol.map(759, 14)});
            this.TO_CLIENT.registerPacket(ScoreboardObjective.class, ScoreboardObjective::new, new ProtocolMapping[]{Protocol.map(47, 59), Protocol.map(107, 63), Protocol.map(335, 65), Protocol.map(338, 66), Protocol.map(393, 69), Protocol.map(477, 73), Protocol.map(573, 74), Protocol.map(755, 83), Protocol.map(760, 86)});
            this.TO_CLIENT.registerPacket(ScoreboardScore.class, ScoreboardScore::new, new ProtocolMapping[]{Protocol.map(47, 60), Protocol.map(107, 66), Protocol.map(335, 68), Protocol.map(338, 69), Protocol.map(393, 72), Protocol.map(477, 76), Protocol.map(573, 77), Protocol.map(755, 86), Protocol.map(760, 89)});
            this.TO_CLIENT.registerPacket(ScoreboardDisplay.class, ScoreboardDisplay::new, new ProtocolMapping[]{Protocol.map(47, 61), Protocol.map(107, 56), Protocol.map(335, 58), Protocol.map(338, 59), Protocol.map(393, 62), Protocol.map(477, 66), Protocol.map(573, 67), Protocol.map(755, 76), Protocol.map(760, 79)});
            this.TO_CLIENT.registerPacket(Team.class, Team::new, new ProtocolMapping[]{Protocol.map(47, 62), Protocol.map(107, 65), Protocol.map(335, 67), Protocol.map(338, 68), Protocol.map(393, 71), Protocol.map(477, 75), Protocol.map(573, 76), Protocol.map(755, 85), Protocol.map(760, 88)});
            this.TO_CLIENT.registerPacket(PluginMessage.class, PluginMessage::new, new ProtocolMapping[]{Protocol.map(47, 63), Protocol.map(107, 24), Protocol.map(393, 25), Protocol.map(477, 24), Protocol.map(573, 25), Protocol.map(735, 24), Protocol.map(751, 23), Protocol.map(755, 24), Protocol.map(759, 21), Protocol.map(760, 22)});
            this.TO_CLIENT.registerPacket(Kick.class, Kick::new, new ProtocolMapping[]{Protocol.map(47, 64), Protocol.map(107, 26), Protocol.map(393, 27), Protocol.map(477, 26), Protocol.map(573, 27), Protocol.map(735, 26), Protocol.map(751, 25), Protocol.map(755, 26), Protocol.map(759, 23), Protocol.map(760, 25)});
            this.TO_CLIENT.registerPacket(Title.class, Title::new, new ProtocolMapping[]{Protocol.map(47, 69), Protocol.map(335, 71), Protocol.map(338, 72), Protocol.map(393, 75), Protocol.map(477, 79), Protocol.map(573, 80), Protocol.map(735, 79), Protocol.map(755, 89), Protocol.map(757, 90), Protocol.map(760, 93)});
            this.TO_CLIENT.registerPacket(ClearTitles.class, ClearTitles::new, new ProtocolMapping[]{Protocol.map(755, 16), Protocol.map(759, 13)});
            this.TO_CLIENT.registerPacket(Subtitle.class, Subtitle::new, new ProtocolMapping[]{Protocol.map(755, 87), Protocol.map(757, 88), Protocol.map(760, 91)});
            this.TO_CLIENT.registerPacket(TitleTimes.class, TitleTimes::new, new ProtocolMapping[]{Protocol.map(755, 90), Protocol.map(757, 91), Protocol.map(760, 94)});
            this.TO_CLIENT.registerPacket(SystemChat.class, SystemChat::new, new ProtocolMapping[]{Protocol.map(759, 95), Protocol.map(760, 98)});
            this.TO_CLIENT.registerPacket(PlayerListHeaderFooter.class, PlayerListHeaderFooter::new, new ProtocolMapping[]{Protocol.map(47, 71), Protocol.map(107, 72), Protocol.map(110, 71), Protocol.map(335, 73), Protocol.map(338, 74), Protocol.map(393, 78), Protocol.map(477, 83), Protocol.map(573, 84), Protocol.map(735, 83), Protocol.map(755, 94), Protocol.map(757, 95), Protocol.map(759, 96), Protocol.map(760, 99)});
            this.TO_CLIENT.registerPacket(EntityStatus.class, EntityStatus::new, new ProtocolMapping[]{Protocol.map(47, 26), Protocol.map(107, 27), Protocol.map(393, 28), Protocol.map(477, 27), Protocol.map(573, 28), Protocol.map(735, 27), Protocol.map(751, 26), Protocol.map(755, 27), Protocol.map(759, 24), Protocol.map(760, 26)});
            this.TO_CLIENT.registerPacket(Commands.class, Commands::new, new ProtocolMapping[]{Protocol.map(393, 17), Protocol.map(573, 18), Protocol.map(735, 17), Protocol.map(751, 16), Protocol.map(755, 18), Protocol.map(759, 15)});
            this.TO_CLIENT.registerPacket(GameState.class, GameState::new, new ProtocolMapping[]{Protocol.map(573, 31), Protocol.map(735, 30), Protocol.map(751, 29), Protocol.map(755, 30), Protocol.map(759, 27), Protocol.map(760, 29)});
            this.TO_CLIENT.registerPacket(ViewDistance.class, ViewDistance::new, new ProtocolMapping[]{Protocol.map(477, 65), Protocol.map(573, 66), Protocol.map(735, 65), Protocol.map(755, 74), Protocol.map(759, 73), Protocol.map(760, 76)});
            this.TO_SERVER.registerPacket(KeepAlive.class, KeepAlive::new, new ProtocolMapping[]{Protocol.map(47, 0), Protocol.map(107, 11), Protocol.map(335, 12), Protocol.map(338, 11), Protocol.map(393, 14), Protocol.map(477, 15), Protocol.map(735, 16), Protocol.map(755, 15), Protocol.map(759, 17), Protocol.map(760, 18)});
            this.TO_SERVER.registerPacket(Chat.class, Chat::new, new ProtocolMapping[]{Protocol.map(47, 1), Protocol.map(107, 2), Protocol.map(335, 3), Protocol.map(338, 2), Protocol.map(477, 3), Protocol.map(759, -1)});
            this.TO_SERVER.registerPacket(ClientCommand.class, ClientCommand::new, new ProtocolMapping[]{Protocol.map(759, 3), Protocol.map(760, 4)});
            this.TO_SERVER.registerPacket(ClientChat.class, ClientChat::new, new ProtocolMapping[]{Protocol.map(759, 4), Protocol.map(760, 5)});
            this.TO_SERVER.registerPacket(TabCompleteRequest.class, TabCompleteRequest::new, new ProtocolMapping[]{Protocol.map(47, 20), Protocol.map(107, 1), Protocol.map(335, 2), Protocol.map(338, 1), Protocol.map(393, 5), Protocol.map(477, 6), Protocol.map(759, 8), Protocol.map(760, 9)});
            this.TO_SERVER.registerPacket(ClientSettings.class, ClientSettings::new, new ProtocolMapping[]{Protocol.map(47, 21), Protocol.map(107, 4), Protocol.map(335, 5), Protocol.map(338, 4), Protocol.map(477, 5), Protocol.map(759, 7), Protocol.map(760, 8)});
            this.TO_SERVER.registerPacket(PluginMessage.class, PluginMessage::new, new ProtocolMapping[]{Protocol.map(47, 23), Protocol.map(107, 9), Protocol.map(335, 10), Protocol.map(338, 9), Protocol.map(393, 10), Protocol.map(477, 11), Protocol.map(755, 10), Protocol.map(759, 12), Protocol.map(760, 13)});
        }
    }
    ,
    STATUS{
        {
            this.TO_CLIENT.registerPacket(StatusResponse.class, StatusResponse::new, new ProtocolMapping[]{Protocol.map(47, 0)});
            this.TO_CLIENT.registerPacket(PingPacket.class, PingPacket::new, new ProtocolMapping[]{Protocol.map(47, 1)});
            this.TO_SERVER.registerPacket(StatusRequest.class, StatusRequest::new, new ProtocolMapping[]{Protocol.map(47, 0)});
            this.TO_SERVER.registerPacket(PingPacket.class, PingPacket::new, new ProtocolMapping[]{Protocol.map(47, 1)});
        }
    }
    ,
    LOGIN{
        {
            this.TO_CLIENT.registerPacket(Kick.class, Kick::new, new ProtocolMapping[]{Protocol.map(47, 0)});
            this.TO_CLIENT.registerPacket(EncryptionRequest.class, EncryptionRequest::new, new ProtocolMapping[]{Protocol.map(47, 1)});
            this.TO_CLIENT.registerPacket(LoginSuccess.class, LoginSuccess::new, new ProtocolMapping[]{Protocol.map(47, 2)});
            this.TO_CLIENT.registerPacket(SetCompression.class, SetCompression::new, new ProtocolMapping[]{Protocol.map(47, 3)});
            this.TO_CLIENT.registerPacket(LoginPayloadRequest.class, LoginPayloadRequest::new, new ProtocolMapping[]{Protocol.map(393, 4)});
            this.TO_SERVER.registerPacket(LoginRequest.class, LoginRequest::new, new ProtocolMapping[]{Protocol.map(47, 0)});
            this.TO_SERVER.registerPacket(EncryptionResponse.class, EncryptionResponse::new, new ProtocolMapping[]{Protocol.map(47, 1)});
            this.TO_SERVER.registerPacket(LoginPayloadResponse.class, LoginPayloadResponse::new, new ProtocolMapping[]{Protocol.map(393, 2)});
        }
    };

    public static final int MAX_PACKET_ID = 255;
    final DirectionData TO_SERVER = new DirectionData(this, ProtocolConstants.Direction.TO_SERVER);
    final DirectionData TO_CLIENT = new DirectionData(this, ProtocolConstants.Direction.TO_CLIENT);

    public static void main(String[] args) {
        for (int version : ProtocolConstants.SUPPORTED_VERSION_IDS) {
            Protocol.dump(version);
        }
    }

    private static void dump(int version) {
        for (Protocol protocol : Protocol.values()) {
            Protocol.dump(version, protocol);
        }
    }

    private static void dump(int version, Protocol protocol) {
        Protocol.dump(version, protocol.TO_CLIENT);
        Protocol.dump(version, protocol.TO_SERVER);
    }

    private static void dump(int version, DirectionData data) {
        for (int id = 0; id < 255; ++id) {
            DefinedPacket packet = data.createPacket(id, version);
            if (packet == null) continue;
            System.out.println(version + " " + (Object)((Object)data.protocolPhase) + " " + (Object)((Object)data.direction) + " " + id + " " + packet.getClass().getSimpleName());
        }
    }

    private static ProtocolMapping map(int protocol, int id) {
        return new ProtocolMapping(protocol, id);
    }

    static final class DirectionData {
        private final TIntObjectMap<ProtocolData> protocols = new TIntObjectHashMap();
        private final Protocol protocolPhase;
        private final ProtocolConstants.Direction direction;

        public DirectionData(Protocol protocolPhase, ProtocolConstants.Direction direction) {
            this.protocolPhase = protocolPhase;
            this.direction = direction;
            for (int protocol : ProtocolConstants.SUPPORTED_VERSION_IDS) {
                this.protocols.put(protocol, (Object)new ProtocolData(protocol));
            }
        }

        private ProtocolData getProtocolData(int version) {
            ProtocolData protocol = (ProtocolData)this.protocols.get(version);
            if (protocol == null && this.protocolPhase != GAME) {
                protocol = (ProtocolData)Iterables.getFirst((Iterable)this.protocols.valueCollection(), null);
            }
            return protocol;
        }

        public boolean hasPacket(int i, boolean supportsForge) {
            return supportsForge || i >= 0 && i <= 255;
        }

        public final DefinedPacket createPacket(int id, int version) {
            return this.createPacket(id, version, true);
        }

        public final DefinedPacket createPacket(int id, int version, boolean supportsForge) {
            ProtocolData protocolData = this.getProtocolData(version);
            if (protocolData == null) {
                throw new BadPacketException("Unsupported protocol version " + version);
            }
            if (!this.hasPacket(id, supportsForge)) {
                throw new BadPacketException("Packet with id " + id + " outside of range");
            }
            Supplier constructor = protocolData.packetConstructors[id];
            return constructor == null ? null : (DefinedPacket)constructor.get();
        }

        private void registerPacket(Class<? extends DefinedPacket> packetClass, Supplier<? extends DefinedPacket> constructor, ProtocolMapping ... mappings) {
            int mappingIndex = 0;
            ProtocolMapping mapping = mappings[mappingIndex];
            for (int protocol : ProtocolConstants.SUPPORTED_VERSION_IDS) {
                ProtocolMapping nextMapping;
                if (protocol < mapping.protocolVersion) continue;
                if (mapping.protocolVersion < protocol && mappingIndex + 1 < mappings.length && (nextMapping = mappings[mappingIndex + 1]).protocolVersion == protocol) {
                    Preconditions.checkState((nextMapping.packetID != mapping.packetID ? 1 : 0) != 0, (String)"Duplicate packet mapping (%s, %s)", (int)mapping.protocolVersion, (int)nextMapping.protocolVersion);
                    mapping = nextMapping;
                    ++mappingIndex;
                }
                if (mapping.packetID < 0) break;
                ProtocolData data = (ProtocolData)this.protocols.get(protocol);
                data.packetMap.put(packetClass, mapping.packetID);
                ((ProtocolData)data).packetConstructors[((ProtocolMapping)mapping).packetID] = constructor;
            }
        }

        final int getId(Class<? extends DefinedPacket> packet, int version) {
            ProtocolData protocolData = this.getProtocolData(version);
            if (protocolData == null) {
                throw new BadPacketException("Unsupported protocol version");
            }
            int packetId = protocolData.packetMap.get(packet);
            Preconditions.checkArgument((packetId >= 0 ? 1 : 0) != 0, (String)"Cannot get ID for packet %s in phase %s with direction %s for protocol version %s", packet, (Object)((Object)this.protocolPhase), (Object)((Object)this.direction), (Object)version);
            return packetId;
        }

        public ProtocolConstants.Direction getDirection() {
            return this.direction;
        }
    }

    private static class ProtocolMapping {
        private final int protocolVersion;
        private final int packetID;

        public ProtocolMapping(int protocolVersion, int packetID) {
            this.protocolVersion = protocolVersion;
            this.packetID = packetID;
        }

        public int getProtocolVersion() {
            return this.protocolVersion;
        }

        public int getPacketID() {
            return this.packetID;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProtocolMapping)) {
                return false;
            }
            ProtocolMapping other = (ProtocolMapping)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getProtocolVersion() != other.getProtocolVersion()) {
                return false;
            }
            return this.getPacketID() == other.getPacketID();
        }

        protected boolean canEqual(Object other) {
            return other instanceof ProtocolMapping;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getProtocolVersion();
            result = result * 59 + this.getPacketID();
            return result;
        }

        public String toString() {
            return "Protocol.ProtocolMapping(protocolVersion=" + this.getProtocolVersion() + ", packetID=" + this.getPacketID() + ")";
        }
    }

    private static class ProtocolData {
        private final int protocolVersion;
        private final TObjectIntMap<Class<? extends DefinedPacket>> packetMap = new TObjectIntHashMap(255);
        private final Supplier<? extends DefinedPacket>[] packetConstructors = new Supplier[255];

        public ProtocolData(int protocolVersion) {
            this.protocolVersion = protocolVersion;
        }

        public int getProtocolVersion() {
            return this.protocolVersion;
        }

        public TObjectIntMap<Class<? extends DefinedPacket>> getPacketMap() {
            return this.packetMap;
        }

        public Supplier<? extends DefinedPacket>[] getPacketConstructors() {
            return this.packetConstructors;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProtocolData)) {
                return false;
            }
            ProtocolData other = (ProtocolData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getProtocolVersion() != other.getProtocolVersion()) {
                return false;
            }
            TObjectIntMap<Class<? extends DefinedPacket>> this$packetMap = this.getPacketMap();
            TObjectIntMap<Class<? extends DefinedPacket>> other$packetMap = other.getPacketMap();
            if (this$packetMap == null ? other$packetMap != null : !this$packetMap.equals(other$packetMap)) {
                return false;
            }
            return Arrays.deepEquals(this.getPacketConstructors(), other.getPacketConstructors());
        }

        protected boolean canEqual(Object other) {
            return other instanceof ProtocolData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getProtocolVersion();
            TObjectIntMap<Class<? extends DefinedPacket>> $packetMap = this.getPacketMap();
            result = result * 59 + ($packetMap == null ? 43 : $packetMap.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getPacketConstructors());
            return result;
        }

        public String toString() {
            return "Protocol.ProtocolData(protocolVersion=" + this.getProtocolVersion() + ", packetMap=" + this.getPacketMap() + ", packetConstructors=" + Arrays.deepToString(this.getPacketConstructors()) + ")";
        }
    }
}

