/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class ClientCommand
extends DefinedPacket {
    private String command;
    private long timestamp;
    private long salt;
    private Map<String, byte[]> signatures;
    private boolean signedPreview;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.command = ClientCommand.readString(buf);
        this.timestamp = buf.readLong();
        this.salt = buf.readLong();
        int cnt = ClientCommand.readVarInt(buf);
        Preconditions.checkArgument((cnt <= 8 ? 1 : 0) != 0, (Object)"Too many signatures");
        this.signatures = new HashMap<String, byte[]>(cnt);
        for (int i = 0; i < cnt; ++i) {
            this.signatures.put(ClientCommand.readString(buf, 16), ClientCommand.readArray(buf));
        }
        this.signedPreview = buf.readBoolean();
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        ClientCommand.writeString(this.command, buf);
        buf.writeLong(this.timestamp);
        buf.writeLong(this.salt);
        ClientCommand.writeVarInt(this.signatures.size(), buf);
        for (Map.Entry<String, byte[]> entry : this.signatures.entrySet()) {
            ClientCommand.writeString(entry.getKey(), buf);
            ClientCommand.writeArray(entry.getValue(), buf);
        }
        buf.writeBoolean(this.signedPreview);
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public String getCommand() {
        return this.command;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getSalt() {
        return this.salt;
    }

    public Map<String, byte[]> getSignatures() {
        return this.signatures;
    }

    public boolean isSignedPreview() {
        return this.signedPreview;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setSalt(long salt) {
        this.salt = salt;
    }

    public void setSignatures(Map<String, byte[]> signatures) {
        this.signatures = signatures;
    }

    public void setSignedPreview(boolean signedPreview) {
        this.signedPreview = signedPreview;
    }

    @Override
    public String toString() {
        return "ClientCommand(command=" + this.getCommand() + ", timestamp=" + this.getTimestamp() + ", salt=" + this.getSalt() + ", signatures=" + this.getSignatures() + ", signedPreview=" + this.isSignedPreview() + ")";
    }

    public ClientCommand() {
    }

    public ClientCommand(String command, long timestamp, long salt, Map<String, byte[]> signatures, boolean signedPreview) {
        this.command = command;
        this.timestamp = timestamp;
        this.salt = salt;
        this.signatures = signatures;
        this.signedPreview = signedPreview;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientCommand)) {
            return false;
        }
        ClientCommand other = (ClientCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        if (this.getSalt() != other.getSalt()) {
            return false;
        }
        if (this.isSignedPreview() != other.isSignedPreview()) {
            return false;
        }
        String this$command = this.getCommand();
        String other$command = other.getCommand();
        if (this$command == null ? other$command != null : !this$command.equals(other$command)) {
            return false;
        }
        Map<String, byte[]> this$signatures = this.getSignatures();
        Map<String, byte[]> other$signatures = other.getSignatures();
        return !(this$signatures == null ? other$signatures != null : !((Object)this$signatures).equals(other$signatures));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientCommand;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        long $salt = this.getSalt();
        result = result * 59 + (int)($salt >>> 32 ^ $salt);
        result = result * 59 + (this.isSignedPreview() ? 79 : 97);
        String $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : $command.hashCode());
        Map<String, byte[]> $signatures = this.getSignatures();
        result = result * 59 + ($signatures == null ? 43 : ((Object)$signatures).hashCode());
        return result;
    }
}

