/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.PlayerPublicKey;
import net.md_5.bungee.protocol.ProtocolConstants;

public class LoginRequest
extends DefinedPacket {
    private String data;
    private PlayerPublicKey publicKey;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.data = LoginRequest.readString(buf, 16);
        if (protocolVersion >= 759) {
            this.publicKey = LoginRequest.readPublicKey(buf);
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        LoginRequest.writeString(this.data, buf);
        if (protocolVersion >= 759) {
            LoginRequest.writePublicKey(this.publicKey, buf);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    @Override
    public int expectedMaxLength(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (protocolVersion >= 759) {
            return -1;
        }
        return 65;
    }

    public String getData() {
        return this.data;
    }

    public PlayerPublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setPublicKey(PlayerPublicKey publicKey) {
        this.publicKey = publicKey;
    }

    @Override
    public String toString() {
        return "LoginRequest(data=" + this.getData() + ", publicKey=" + this.getPublicKey() + ")";
    }

    public LoginRequest() {
    }

    public LoginRequest(String data, PlayerPublicKey publicKey) {
        this.data = data;
        this.publicKey = publicKey;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoginRequest)) {
            return false;
        }
        LoginRequest other = (LoginRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        PlayerPublicKey this$publicKey = this.getPublicKey();
        PlayerPublicKey other$publicKey = other.getPublicKey();
        return !(this$publicKey == null ? other$publicKey != null : !((Object)this$publicKey).equals(other$publicKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LoginRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        PlayerPublicKey $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : ((Object)$publicKey).hashCode());
        return result;
    }
}

