/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.lang.constant.Constable;
import java.util.List;
import net.md_5.bungee.protocol.BadPacketException;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.FastDecoderException;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.ProtocolConstants;

public class MinecraftDecoder
extends MessageToMessageDecoder<ByteBuf> {
    private Protocol protocol;
    private final boolean server;
    private int protocolVersion;
    private boolean supportsForge = false;
    public static final boolean DEBUG = Boolean.getBoolean("waterfall.packet-decode-logging");
    private static final CorruptedFrameException PACKET_LENGTH_OVERSIZED = new CorruptedFrameException("A packet could not be decoded because it was too large. For more information, launch Waterfall with -Dwaterfall.packet-decode-logging=true");
    private static final CorruptedFrameException PACKET_LENGTH_UNDERSIZED = new CorruptedFrameException("A packet could not be decoded because it was smaller than allowed. For more information, launch Waterfall with -Dwaterfall.packet-decode-logging=true");
    private static final BadPacketException PACKET_NOT_READ_TO_END = new BadPacketException("Couldn't read all bytes from a packet. For more information, launch Waterfall with -Dwaterfall.packet-decode-logging=true");

    public MinecraftDecoder(Protocol protocol, boolean server, int protocolVersion) {
        this.protocol = protocol;
        this.server = server;
        this.protocolVersion = protocolVersion;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (!ctx.channel().isActive()) {
            return;
        }
        Protocol.DirectionData prot = this.server ? this.protocol.TO_SERVER : this.protocol.TO_CLIENT;
        ByteBuf slice = in.copy();
        Constable packetTypeInfo = null;
        try {
            if (in.readableBytes() == 0 && this.server) {
                return;
            }
            int packetId = DefinedPacket.readVarInt(in);
            packetTypeInfo = packetId;
            DefinedPacket packet = prot.createPacket(packetId, this.protocolVersion, this.supportsForge);
            if (packet != null) {
                packetTypeInfo = packet.getClass();
                this.doLengthSanityChecks(in, packet, prot.getDirection(), packetId);
                packet.read(in, prot.getDirection(), this.protocolVersion);
                if (in.isReadable()) {
                    if (!DEBUG) {
                        throw PACKET_NOT_READ_TO_END;
                    }
                    throw new BadPacketException("Did not read all bytes from packet " + packet.getClass() + " " + packetId + " Protocol " + (Object)((Object)this.protocol) + " Direction " + (Object)((Object)prot.getDirection()));
                }
            } else {
                in.skipBytes(in.readableBytes());
            }
            out.add(new PacketWrapper(packet, slice));
            slice = null;
        }
        catch (IndexOutOfBoundsException | BadPacketException e) {
            if (!DEBUG) {
                throw e;
            }
            String packetTypeStr = packetTypeInfo instanceof Integer ? "id " + Integer.toHexString(packetTypeInfo) : (packetTypeInfo instanceof Class ? "class " + ((Class)packetTypeInfo).getSimpleName() : "unknown");
            throw new FastDecoderException("Error decoding packet " + packetTypeStr + " with contents:\n" + ByteBufUtil.prettyHexDump((ByteBuf)slice), e);
        }
        finally {
            if (slice != null) {
                slice.release();
            }
        }
    }

    private void doLengthSanityChecks(ByteBuf buf, DefinedPacket packet, ProtocolConstants.Direction direction, int packetId) throws Exception {
        int expectedMinLen = packet.expectedMinLength(buf, direction, this.protocolVersion);
        int expectedMaxLen = packet.expectedMaxLength(buf, direction, this.protocolVersion);
        if (expectedMaxLen != -1 && buf.readableBytes() > expectedMaxLen) {
            throw this.handleOverflow(packet, expectedMaxLen, buf.readableBytes(), packetId);
        }
        if (buf.readableBytes() < expectedMinLen) {
            throw this.handleUnderflow(packet, expectedMaxLen, buf.readableBytes(), packetId);
        }
    }

    private Exception handleOverflow(DefinedPacket packet, int expected, int actual, int packetId) {
        if (DEBUG) {
            throw new CorruptedFrameException("Packet " + packet.getClass() + " " + packetId + " Protocol " + this.protocolVersion + " was too big (expected " + expected + " bytes, got " + actual + " bytes)");
        }
        return PACKET_LENGTH_OVERSIZED;
    }

    private Exception handleUnderflow(DefinedPacket packet, int expected, int actual, int packetId) {
        if (DEBUG) {
            throw new CorruptedFrameException("Packet " + packet.getClass() + " " + packetId + " Protocol " + this.protocolVersion + " was too small (expected " + expected + " bytes, got " + actual + " bytes)");
        }
        return PACKET_LENGTH_UNDERSIZED;
    }

    public MinecraftDecoder(Protocol protocol, boolean server, int protocolVersion, boolean supportsForge) {
        this.protocol = protocol;
        this.server = server;
        this.protocolVersion = protocolVersion;
        this.supportsForge = supportsForge;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setProtocolVersion(int protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public void setSupportsForge(boolean supportsForge) {
        this.supportsForge = supportsForge;
    }
}

