/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class TabCompleteResponse
extends DefinedPacket {
    private int transactionId;
    private Suggestions suggestions;
    private List<String> commands;

    public TabCompleteResponse(int transactionId, Suggestions suggestions) {
        this.transactionId = transactionId;
        this.suggestions = suggestions;
    }

    public TabCompleteResponse(List<String> commands) {
        this.commands = commands;
    }

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (protocolVersion >= 393) {
            this.transactionId = TabCompleteResponse.readVarInt(buf);
            int start = TabCompleteResponse.readVarInt(buf);
            int length = TabCompleteResponse.readVarInt(buf);
            StringRange range = StringRange.between((int)start, (int)(start + length));
            int cnt = TabCompleteResponse.readVarInt(buf);
            LinkedList<Suggestion> matches = new LinkedList<Suggestion>();
            for (int i = 0; i < cnt; ++i) {
                String match = TabCompleteResponse.readString(buf);
                String tooltip = buf.readBoolean() ? TabCompleteResponse.readString(buf) : null;
                matches.add(new Suggestion(range, match, (Message)new LiteralMessage(tooltip)));
            }
            this.suggestions = new Suggestions(range, matches);
        }
        if (protocolVersion < 393) {
            this.commands = TabCompleteResponse.readStringArray(buf);
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (protocolVersion >= 393) {
            TabCompleteResponse.writeVarInt(this.transactionId, buf);
            TabCompleteResponse.writeVarInt(this.suggestions.getRange().getStart(), buf);
            TabCompleteResponse.writeVarInt(this.suggestions.getRange().getLength(), buf);
            TabCompleteResponse.writeVarInt(this.suggestions.getList().size(), buf);
            for (Suggestion suggestion : this.suggestions.getList()) {
                TabCompleteResponse.writeString(suggestion.getText(), buf);
                buf.writeBoolean(suggestion.getTooltip() != null && suggestion.getTooltip().getString() != null);
                if (suggestion.getTooltip() == null || suggestion.getTooltip().getString() == null) continue;
                TabCompleteResponse.writeString(suggestion.getTooltip().getString(), buf);
            }
        }
        if (protocolVersion < 393) {
            TabCompleteResponse.writeStringArray(this.commands, buf);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public Suggestions getSuggestions() {
        return this.suggestions;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public void setTransactionId(int transactionId) {
        this.transactionId = transactionId;
    }

    public void setSuggestions(Suggestions suggestions) {
        this.suggestions = suggestions;
    }

    public void setCommands(List<String> commands) {
        this.commands = commands;
    }

    @Override
    public String toString() {
        return "TabCompleteResponse(transactionId=" + this.getTransactionId() + ", suggestions=" + this.getSuggestions() + ", commands=" + this.getCommands() + ")";
    }

    public TabCompleteResponse() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TabCompleteResponse)) {
            return false;
        }
        TabCompleteResponse other = (TabCompleteResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTransactionId() != other.getTransactionId()) {
            return false;
        }
        Suggestions this$suggestions = this.getSuggestions();
        Suggestions other$suggestions = other.getSuggestions();
        if (this$suggestions == null ? other$suggestions != null : !this$suggestions.equals(other$suggestions)) {
            return false;
        }
        List<String> this$commands = this.getCommands();
        List<String> other$commands = other.getCommands();
        return !(this$commands == null ? other$commands != null : !((Object)this$commands).equals(other$commands));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TabCompleteResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTransactionId();
        Suggestions $suggestions = this.getSuggestions();
        result = result * 59 + ($suggestions == null ? 43 : $suggestions.hashCode());
        List<String> $commands = this.getCommands();
        result = result * 59 + ($commands == null ? 43 : ((Object)$commands).hashCode());
        return result;
    }
}

