/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class Respawn
extends DefinedPacket {
    private int dimension;
    private long seed;
    private short difficulty;
    private short gameMode;
    private String levelType;
    private boolean keepAllPlayerData;
    private boolean isDebug;
    private boolean isFlat;
    private String dimensionCodecName;
    private String world;
    private short previousGamemode;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (protocolVersion >= 735) {
            this.dimensionCodecName = Respawn.readString(buf);
            this.world = Respawn.readString(buf);
        } else {
            this.dimension = buf.readInt();
        }
        if (protocolVersion >= 573) {
            this.seed = buf.readLong();
        }
        if (protocolVersion < 477) {
            this.difficulty = buf.readUnsignedByte();
        }
        this.gameMode = buf.readByte();
        if (protocolVersion >= 735) {
            this.previousGamemode = buf.readByte();
            this.isDebug = buf.readBoolean();
            this.isFlat = buf.readBoolean();
            this.keepAllPlayerData = buf.readBoolean();
        } else {
            this.levelType = Respawn.readString(buf);
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (protocolVersion >= 735) {
            Respawn.writeString(this.dimensionCodecName, buf);
            Respawn.writeString(this.world, buf);
        } else {
            buf.writeInt(this.dimension);
        }
        if (protocolVersion >= 573) {
            buf.writeLong(this.seed);
        }
        if (protocolVersion < 477) {
            buf.writeByte((int)this.difficulty);
        }
        buf.writeByte((int)this.gameMode);
        if (protocolVersion >= 735) {
            buf.writeByte((int)this.previousGamemode);
            buf.writeBoolean(this.isDebug);
            buf.writeBoolean(this.isFlat);
            buf.writeBoolean(this.keepAllPlayerData);
        } else {
            Respawn.writeString(this.levelType, buf);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public int getDimension() {
        return this.dimension;
    }

    public long getSeed() {
        return this.seed;
    }

    public short getDifficulty() {
        return this.difficulty;
    }

    public short getGameMode() {
        return this.gameMode;
    }

    public String getLevelType() {
        return this.levelType;
    }

    public boolean isKeepAllPlayerData() {
        return this.keepAllPlayerData;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public boolean isFlat() {
        return this.isFlat;
    }

    public String getDimensionCodecName() {
        return this.dimensionCodecName;
    }

    public String getWorld() {
        return this.world;
    }

    public short getPreviousGamemode() {
        return this.previousGamemode;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public void setDifficulty(short difficulty) {
        this.difficulty = difficulty;
    }

    public void setGameMode(short gameMode) {
        this.gameMode = gameMode;
    }

    public void setLevelType(String levelType) {
        this.levelType = levelType;
    }

    public void setKeepAllPlayerData(boolean keepAllPlayerData) {
        this.keepAllPlayerData = keepAllPlayerData;
    }

    public void setDebug(boolean isDebug) {
        this.isDebug = isDebug;
    }

    public void setFlat(boolean isFlat) {
        this.isFlat = isFlat;
    }

    public void setDimensionCodecName(String dimensionCodecName) {
        this.dimensionCodecName = dimensionCodecName;
    }

    public void setWorld(String world) {
        this.world = world;
    }

    public void setPreviousGamemode(short previousGamemode) {
        this.previousGamemode = previousGamemode;
    }

    @Override
    public String toString() {
        return "Respawn(dimension=" + this.getDimension() + ", seed=" + this.getSeed() + ", difficulty=" + this.getDifficulty() + ", gameMode=" + this.getGameMode() + ", levelType=" + this.getLevelType() + ", keepAllPlayerData=" + this.isKeepAllPlayerData() + ", isDebug=" + this.isDebug() + ", isFlat=" + this.isFlat() + ", dimensionCodecName=" + this.getDimensionCodecName() + ", world=" + this.getWorld() + ", previousGamemode=" + this.getPreviousGamemode() + ")";
    }

    public Respawn() {
    }

    public Respawn(int dimension, long seed, short difficulty, short gameMode, String levelType, boolean keepAllPlayerData, boolean isDebug, boolean isFlat, String dimensionCodecName, String world, short previousGamemode) {
        this.dimension = dimension;
        this.seed = seed;
        this.difficulty = difficulty;
        this.gameMode = gameMode;
        this.levelType = levelType;
        this.keepAllPlayerData = keepAllPlayerData;
        this.isDebug = isDebug;
        this.isFlat = isFlat;
        this.dimensionCodecName = dimensionCodecName;
        this.world = world;
        this.previousGamemode = previousGamemode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Respawn)) {
            return false;
        }
        Respawn other = (Respawn)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDimension() != other.getDimension()) {
            return false;
        }
        if (this.getSeed() != other.getSeed()) {
            return false;
        }
        if (this.getDifficulty() != other.getDifficulty()) {
            return false;
        }
        if (this.getGameMode() != other.getGameMode()) {
            return false;
        }
        String this$levelType = this.getLevelType();
        String other$levelType = other.getLevelType();
        if (this$levelType == null ? other$levelType != null : !this$levelType.equals(other$levelType)) {
            return false;
        }
        if (this.isKeepAllPlayerData() != other.isKeepAllPlayerData()) {
            return false;
        }
        if (this.isDebug() != other.isDebug()) {
            return false;
        }
        if (this.isFlat() != other.isFlat()) {
            return false;
        }
        String this$dimensionCodecName = this.getDimensionCodecName();
        String other$dimensionCodecName = other.getDimensionCodecName();
        if (this$dimensionCodecName == null ? other$dimensionCodecName != null : !this$dimensionCodecName.equals(other$dimensionCodecName)) {
            return false;
        }
        String this$world = this.getWorld();
        String other$world = other.getWorld();
        if (this$world == null ? other$world != null : !this$world.equals(other$world)) {
            return false;
        }
        return this.getPreviousGamemode() == other.getPreviousGamemode();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Respawn;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDimension();
        long $seed = this.getSeed();
        result = result * 59 + (int)($seed >>> 32 ^ $seed);
        result = result * 59 + this.getDifficulty();
        result = result * 59 + this.getGameMode();
        String $levelType = this.getLevelType();
        result = result * 59 + ($levelType == null ? 43 : $levelType.hashCode());
        result = result * 59 + (this.isKeepAllPlayerData() ? 79 : 97);
        result = result * 59 + (this.isDebug() ? 79 : 97);
        result = result * 59 + (this.isFlat() ? 79 : 97);
        String $dimensionCodecName = this.getDimensionCodecName();
        result = result * 59 + ($dimensionCodecName == null ? 43 : $dimensionCodecName.hashCode());
        String $world = this.getWorld();
        result = result * 59 + ($world == null ? 43 : $world.hashCode());
        result = result * 59 + this.getPreviousGamemode();
        return result;
    }
}

