/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.nbt.NBTTag;

public class Login
extends DefinedPacket {
    private int entityId;
    private short gameMode;
    private int dimension;
    private long seed;
    private short difficulty;
    private short maxPlayers;
    private String levelType;
    private int viewDistance;
    private boolean reducedDebugInfo;
    private boolean normalRespawn;
    private boolean isDebug;
    private boolean isFlat;
    private String dimensionCodecName;
    private NBTTag codecTag;
    private String[] worlds;
    private String world;
    private short previousGamemode;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.entityId = buf.readInt();
        this.gameMode = buf.readByte();
        if (protocolVersion >= 735) {
            this.previousGamemode = buf.readByte();
            int worldNameArrayLen = Login.readVarInt(buf);
            this.worlds = new String[worldNameArrayLen];
            for (int iter = 0; iter < worldNameArrayLen; ++iter) {
                this.worlds[iter] = Login.readString(buf);
            }
            this.codecTag = Login.readNBT(buf);
            this.dimensionCodecName = Login.readString(buf);
            this.world = Login.readString(buf);
        } else {
            this.dimension = protocolVersion > 107 ? buf.readInt() : (int)buf.readByte();
        }
        if (protocolVersion >= 573) {
            this.seed = buf.readLong();
        }
        if (protocolVersion < 477) {
            this.difficulty = buf.readUnsignedByte();
        }
        this.maxPlayers = buf.readUnsignedByte();
        if (protocolVersion < 735) {
            this.levelType = Login.readString(buf);
        }
        if (protocolVersion >= 477) {
            this.viewDistance = Login.readVarInt(buf);
        }
        if (protocolVersion >= 29) {
            this.reducedDebugInfo = buf.readBoolean();
        }
        if (protocolVersion >= 573) {
            this.normalRespawn = buf.readBoolean();
        }
        if (protocolVersion >= 735) {
            this.isDebug = buf.readBoolean();
            this.isFlat = buf.readBoolean();
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        buf.writeInt(this.entityId);
        buf.writeByte((int)this.gameMode);
        if (protocolVersion >= 735) {
            buf.writeByte((int)this.previousGamemode);
            Login.writeVarInt(this.worlds.length, buf);
            for (int iter = 0; iter < this.worlds.length; ++iter) {
                Login.writeString(this.worlds[iter], buf);
            }
            Login.writeNBT(this.codecTag, buf);
            Login.writeString(this.dimensionCodecName, buf);
            Login.writeString(this.world, buf);
        } else if (protocolVersion > 107) {
            buf.writeInt(this.dimension);
        } else {
            buf.writeByte(this.dimension);
        }
        if (protocolVersion >= 573) {
            buf.writeLong(this.seed);
        }
        if (protocolVersion < 477) {
            buf.writeByte((int)this.difficulty);
        }
        buf.writeByte((int)this.maxPlayers);
        if (protocolVersion < 735) {
            Login.writeString(this.levelType, buf);
        }
        if (protocolVersion >= 477) {
            Login.writeVarInt(this.viewDistance, buf);
        }
        if (protocolVersion >= 29) {
            buf.writeBoolean(this.reducedDebugInfo);
        }
        if (protocolVersion >= 573) {
            buf.writeBoolean(this.normalRespawn);
        }
        if (protocolVersion >= 735) {
            buf.writeBoolean(this.isDebug);
            buf.writeBoolean(this.isFlat);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public short getGameMode() {
        return this.gameMode;
    }

    public int getDimension() {
        return this.dimension;
    }

    public long getSeed() {
        return this.seed;
    }

    public short getDifficulty() {
        return this.difficulty;
    }

    public short getMaxPlayers() {
        return this.maxPlayers;
    }

    public String getLevelType() {
        return this.levelType;
    }

    public int getViewDistance() {
        return this.viewDistance;
    }

    public boolean isReducedDebugInfo() {
        return this.reducedDebugInfo;
    }

    public boolean isNormalRespawn() {
        return this.normalRespawn;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public boolean isFlat() {
        return this.isFlat;
    }

    public String getDimensionCodecName() {
        return this.dimensionCodecName;
    }

    public NBTTag getCodecTag() {
        return this.codecTag;
    }

    public String[] getWorlds() {
        return this.worlds;
    }

    public String getWorld() {
        return this.world;
    }

    public short getPreviousGamemode() {
        return this.previousGamemode;
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    public void setGameMode(short gameMode) {
        this.gameMode = gameMode;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public void setDifficulty(short difficulty) {
        this.difficulty = difficulty;
    }

    public void setMaxPlayers(short maxPlayers) {
        this.maxPlayers = maxPlayers;
    }

    public void setLevelType(String levelType) {
        this.levelType = levelType;
    }

    public void setViewDistance(int viewDistance) {
        this.viewDistance = viewDistance;
    }

    public void setReducedDebugInfo(boolean reducedDebugInfo) {
        this.reducedDebugInfo = reducedDebugInfo;
    }

    public void setNormalRespawn(boolean normalRespawn) {
        this.normalRespawn = normalRespawn;
    }

    public void setDebug(boolean isDebug) {
        this.isDebug = isDebug;
    }

    public void setFlat(boolean isFlat) {
        this.isFlat = isFlat;
    }

    public void setDimensionCodecName(String dimensionCodecName) {
        this.dimensionCodecName = dimensionCodecName;
    }

    public void setCodecTag(NBTTag codecTag) {
        this.codecTag = codecTag;
    }

    public void setWorlds(String[] worlds) {
        this.worlds = worlds;
    }

    public void setWorld(String world) {
        this.world = world;
    }

    public void setPreviousGamemode(short previousGamemode) {
        this.previousGamemode = previousGamemode;
    }

    @Override
    public String toString() {
        return "Login(entityId=" + this.getEntityId() + ", gameMode=" + this.getGameMode() + ", dimension=" + this.getDimension() + ", seed=" + this.getSeed() + ", difficulty=" + this.getDifficulty() + ", maxPlayers=" + this.getMaxPlayers() + ", levelType=" + this.getLevelType() + ", viewDistance=" + this.getViewDistance() + ", reducedDebugInfo=" + this.isReducedDebugInfo() + ", normalRespawn=" + this.isNormalRespawn() + ", isDebug=" + this.isDebug() + ", isFlat=" + this.isFlat() + ", dimensionCodecName=" + this.getDimensionCodecName() + ", codecTag=" + this.getCodecTag() + ", worlds=" + Arrays.deepToString(this.getWorlds()) + ", world=" + this.getWorld() + ", previousGamemode=" + this.getPreviousGamemode() + ")";
    }

    public Login() {
    }

    public Login(int entityId, short gameMode, int dimension, long seed, short difficulty, short maxPlayers, String levelType, int viewDistance, boolean reducedDebugInfo, boolean normalRespawn, boolean isDebug, boolean isFlat, String dimensionCodecName, NBTTag codecTag, String[] worlds, String world, short previousGamemode) {
        this.entityId = entityId;
        this.gameMode = gameMode;
        this.dimension = dimension;
        this.seed = seed;
        this.difficulty = difficulty;
        this.maxPlayers = maxPlayers;
        this.levelType = levelType;
        this.viewDistance = viewDistance;
        this.reducedDebugInfo = reducedDebugInfo;
        this.normalRespawn = normalRespawn;
        this.isDebug = isDebug;
        this.isFlat = isFlat;
        this.dimensionCodecName = dimensionCodecName;
        this.codecTag = codecTag;
        this.worlds = worlds;
        this.world = world;
        this.previousGamemode = previousGamemode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Login)) {
            return false;
        }
        Login other = (Login)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        if (this.getGameMode() != other.getGameMode()) {
            return false;
        }
        if (this.getDimension() != other.getDimension()) {
            return false;
        }
        if (this.getSeed() != other.getSeed()) {
            return false;
        }
        if (this.getDifficulty() != other.getDifficulty()) {
            return false;
        }
        if (this.getMaxPlayers() != other.getMaxPlayers()) {
            return false;
        }
        String this$levelType = this.getLevelType();
        String other$levelType = other.getLevelType();
        if (this$levelType == null ? other$levelType != null : !this$levelType.equals(other$levelType)) {
            return false;
        }
        if (this.getViewDistance() != other.getViewDistance()) {
            return false;
        }
        if (this.isReducedDebugInfo() != other.isReducedDebugInfo()) {
            return false;
        }
        if (this.isNormalRespawn() != other.isNormalRespawn()) {
            return false;
        }
        if (this.isDebug() != other.isDebug()) {
            return false;
        }
        if (this.isFlat() != other.isFlat()) {
            return false;
        }
        String this$dimensionCodecName = this.getDimensionCodecName();
        String other$dimensionCodecName = other.getDimensionCodecName();
        if (this$dimensionCodecName == null ? other$dimensionCodecName != null : !this$dimensionCodecName.equals(other$dimensionCodecName)) {
            return false;
        }
        NBTTag this$codecTag = this.getCodecTag();
        NBTTag other$codecTag = other.getCodecTag();
        if (this$codecTag == null ? other$codecTag != null : !this$codecTag.equals(other$codecTag)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getWorlds(), other.getWorlds())) {
            return false;
        }
        String this$world = this.getWorld();
        String other$world = other.getWorld();
        if (this$world == null ? other$world != null : !this$world.equals(other$world)) {
            return false;
        }
        return this.getPreviousGamemode() == other.getPreviousGamemode();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Login;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + this.getGameMode();
        result = result * 59 + this.getDimension();
        long $seed = this.getSeed();
        result = result * 59 + (int)($seed >>> 32 ^ $seed);
        result = result * 59 + this.getDifficulty();
        result = result * 59 + this.getMaxPlayers();
        String $levelType = this.getLevelType();
        result = result * 59 + ($levelType == null ? 43 : $levelType.hashCode());
        result = result * 59 + this.getViewDistance();
        result = result * 59 + (this.isReducedDebugInfo() ? 79 : 97);
        result = result * 59 + (this.isNormalRespawn() ? 79 : 97);
        result = result * 59 + (this.isDebug() ? 79 : 97);
        result = result * 59 + (this.isFlat() ? 79 : 97);
        String $dimensionCodecName = this.getDimensionCodecName();
        result = result * 59 + ($dimensionCodecName == null ? 43 : $dimensionCodecName.hashCode());
        NBTTag $codecTag = this.getCodecTag();
        result = result * 59 + ($codecTag == null ? 43 : $codecTag.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getWorlds());
        String $world = this.getWorld();
        result = result * 59 + ($world == null ? 43 : $world.hashCode());
        result = result * 59 + this.getPreviousGamemode();
        return result;
    }
}

