/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.nbt;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import net.md_5.bungee.protocol.nbt.NBTTag;
import net.md_5.bungee.protocol.nbt.NBTTagTypes;

public class ListTag
extends NBTTag {
    private ArrayList<NBTTag> values = new ArrayList();
    private byte tagType;

    @Override
    public int getTagIndex() {
        return 9;
    }

    @Override
    public void write(DataOutput to) throws IOException {
        if (this.values.isEmpty()) {
            to.writeByte(0);
            to.writeInt(0);
        } else {
            to.writeByte(this.tagType);
            to.writeInt(this.values.size());
            for (NBTTag iter : this.values) {
                iter.write(to);
            }
        }
    }

    @Override
    public void read(DataInput from) throws IOException {
        this.tagType = from.readByte();
        int len = from.readInt();
        if (this.tagType == 0 && len > 0) {
            throw new IOException("ListTag contained filled EndTag or type for Tag was invalid");
        }
        ArrayList read = Lists.newArrayListWithCapacity((int)len);
        for (int i = 0; i < len; ++i) {
            NBTTag inst = NBTTagTypes.newInstance(this.tagType);
            inst.read(from);
            read.add(inst);
        }
        this.values = read;
    }

    @Override
    public String toString() {
        String ret = "ListTag (Type: " + this.tagType + " : \n";
        for (NBTTag d : this.values) {
            ret = ret + "\t" + d.toString() + "\n";
        }
        return ret;
    }
}

