package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

@Data
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = false)
public class Respawn extends DefinedPacket
{

    private int dimension;
    private long seed;
    private short difficulty;
    private short gameMode;
    private String levelType;
    private boolean keepAllPlayerData; // Waterfall (1.16: 20w18a+)
    private boolean isDebug; // Waterfall (1.16: 20w20a+)
    private boolean isFlat; // Waterfall (1.16: 20w20a+)
    private String dimensionCodecName; // Waterfall (1.16: 20w21a+)
    private String world; // Waterfall (1.16: 20w22a+)
    private short previousGamemode; // Waterfall (1.16: pre6)

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion)
    {
        // Waterfall (1.16: 20w21a+) start:
        if ( protocolVersion >= ProtocolConstants.MINECRAFT_1_16 )
        {
            dimensionCodecName = readString( buf );
            world = readString( buf ); // Waterfall (1.16: 20w22a+)
        } else
        {
            dimension = buf.readInt();
        }
        // Waterfall end
        if ( protocolVersion >= ProtocolConstants.MINECRAFT_1_15 )
        {
            seed = buf.readLong();
        }
        if ( protocolVersion < ProtocolConstants.MINECRAFT_1_14 )
        {
            difficulty = buf.readUnsignedByte();
        }
        gameMode = buf.readByte(); // Waterfall (1.16: pre6) Change to signed for consistency
        // Waterfall (1.16: 20w20+) start:
        if( protocolVersion >= ProtocolConstants.MINECRAFT_1_16 )
        {
            // Waterfall (1.16: pre6) previous gamemode (F3 menu)
            previousGamemode = buf.readByte();
            isDebug = buf.readBoolean();
            isFlat = buf.readBoolean();
            keepAllPlayerData = buf.readBoolean();
        } else
        {
            levelType = readString( buf );
        }
        // Waterfall end
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion)
    {
        // Waterfall (1.16: 20w21a+) start:
        if ( protocolVersion >= ProtocolConstants.MINECRAFT_1_16 )
        {
           writeString( dimensionCodecName, buf );
           writeString( world, buf ); // Waterfall (1.16: 20w22a+)
        } else
        {
            buf.writeInt( dimension );
        }
        // Waterfall end
        if ( protocolVersion >= ProtocolConstants.MINECRAFT_1_15 )
        {
            buf.writeLong( seed );
        }
        if ( protocolVersion < ProtocolConstants.MINECRAFT_1_14 )
        {
            buf.writeByte( difficulty );
        }
        buf.writeByte( gameMode );
        // Waterfall (1.16: 20w18a+) start:
        if( protocolVersion >= ProtocolConstants.MINECRAFT_1_16 )
        {
            // Waterfall (1.16: pre6) previous gamemode (F3 menu)
            buf.writeByte( previousGamemode );
            buf.writeBoolean( isDebug );
            buf.writeBoolean( isFlat );
            buf.writeBoolean( keepAllPlayerData );
        } else
        {
            writeString( levelType, buf );
        }
        // Waterfall end
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception
    {
        handler.handle( this );
    }
}
