package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

import java.util.UUID;

@Data
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = false)
public class LoginSuccess extends DefinedPacket
{

    private String uuid;
    private String username;
    private int protocolVersion; // Waterfall (1.16: 20w12a+)

    @Override
    public void read(ByteBuf buf)
    {
        // Waterfall (1.16: 20w12a+ UUID is now a four-int array) start
        if( protocolVersion >= ProtocolConstants.MINECRAFT_1_16 )
        {
            uuid = readUUIDIntArray( buf ).toString();
        } else {
            uuid = readString( buf );
        }
        // Waterfall end
        username = readString( buf );
    }

    @Override
    public void write(ByteBuf buf)
    {
        // Waterfall (1.16: 20w12a+ UUID is now a four-int array) start
        if( protocolVersion >= ProtocolConstants.MINECRAFT_1_16 )
        {
            writeUUIDIntArray( UUID.fromString( uuid ), buf);
        } else {
            writeString( uuid, buf );
        }
        // Waterfall end
        writeString( username, buf );
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception
    {
        handler.handle( this );
    }

    // Waterfall (1.16: 20w12a+ forward protocol version) start
    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion){
        this.protocolVersion = protocolVersion;
        read(buf);
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion){
        this.protocolVersion = protocolVersion;
        write(buf);
    }
    // Waterfall end
}
