package net.md_5.bungee.protocol.nbt;

import java.io.IOException;

/*
 * Waterfall NBT-Library substitute module
 * Minecraft 1.16 - 20w21a+
 * by Xernium (Five)
 * */


public class NBTTagTypes {

    public static NBTTag newInstance( byte id ) throws IOException
    {
        switch( id )
        {
            case 0:
                return new EndTag();
            case 1:
                return new ByteTag();
            case 3:
                return new IntTag();
            case 4:
                return new LongTag();
            case 5:
                return new FloatTag();
            case 8:
                return new StringTag();
            case 9:
                return new ListTag();
            case 10:
                return new CompoundTag();
            default:
                throw new IOException( "Unsupported NBT ID: " + id );
        }
    }

}
