package net.md_5.bungee.protocol.nbt;

import com.google.common.collect.Lists;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;

/*
 * Waterfall NBT-Library substitute module
 * Minecraft 1.16 - 20w21a+
 * by Xernium (Five)
 * */


public class ListTag extends NBTTag {

    private ArrayList<NBTTag> values = new ArrayList<NBTTag>();
    private byte tagType;

    @Override
    public int getTagIndex()
    {
        return 9;
    }

    @Override
    public void write( DataOutput to ) throws IOException
    {
        if( values.isEmpty() )
        {
            to.writeByte( 0 );
            to.writeInt( 0 );
        } else{
            to.writeByte( tagType );
            to.writeInt( values.size() );

            for(NBTTag iter : values)
            {
                iter.write(to);
            }

        }
    }

    @Override
    public void read(DataInput from) throws IOException
    {
        tagType = from.readByte();
        int len = from.readInt();
        if( tagType == 0 && len > 0 )
        {
            throw new IOException( "ListTag contained filled EndTag or type for Tag was invalid" );
        } else
        {
            ArrayList<NBTTag> read = Lists.newArrayListWithCapacity( len );
            for( int i = 0; i < len; i++ )
            {
                NBTTag inst = NBTTagTypes.newInstance( tagType );
                inst.read( from );
                read.add( inst );
            }
            values = read;
        }
    }

    @Override
    public String toString()
    {
        String ret = "ListTag (Type: " + tagType + " : \n";
        for( NBTTag d : values )
        {
           ret += "\t" + d.toString() + "\n";
        }
        return ret;
    }
}
