package net.md_5.bungee.protocol.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

/*
 * Waterfall NBT-Library substitute module
 * Minecraft 1.16 - 20w21a+
 * by Xernium (Five)
 * */

public class IntTag extends NBTTag {

    private int value;

    @Override
    public int getTagIndex()
    {
        return 3;
    }

    @Override
    public void write( DataOutput to ) throws IOException
    {
        to.writeInt( value );
    }

    @Override
    public void read( DataInput from ) throws IOException
    {
        value = from.readInt();
    }

    @Override
    public String toString()
    {
        return "value: '" + value + "'\n";
    }


}
