package net.md_5.bungee.protocol.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

/*
 * Waterfall NBT-Library substitute module
 * Minecraft 1.16 - 20w21a+
 * by Xernium (Five)
 * */

public class FloatTag extends NBTTag {

    private float value;

    @Override
    public int getTagIndex()
    {
        return 5;
    }

    @Override
    public void write( DataOutput to ) throws IOException
    {
        to.writeFloat( value );
    }

    @Override
    public void read( DataInput from ) throws IOException
    {
        value = from.readFloat();
    }

    @Override
    public String toString()
    {
        return "value: '" + value + "'\n";
    }


}
