package net.md_5.bungee.protocol.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * Waterfall NBT-Library substitute module
 * Minecraft 1.16 - 20w21a+
 * by Xernium (Five)
 * */

public class CompoundTag extends NBTTag {

    private Map<String, NBTTag> tagMap = new HashMap<String, NBTTag>();

    @Override
    public int getTagIndex()
    {
        return 10;
    }

    @Override
    public void write( DataOutput to ) throws IOException
    {
        for( Map.Entry<String, NBTTag> entry : tagMap.entrySet() )
        {
            to.writeByte( entry.getValue().getTagIndex() );
            if( entry.getValue().getTagIndex() != 0 )
            {
                to.writeUTF( entry.getKey() );
                entry.getValue().write( to );
            }
        }

        to.writeByte( 0 );
    }

    @Override
    public void read( DataInput from ) throws IOException
    {
        tagMap = new HashMap<String, NBTTag>();
        for ( byte type = from.readByte(); type != 0; type = from.readByte())
        {
            String key = from.readUTF();
            NBTTag value = NBTTagTypes.newInstance( type );
            value.read( from );
            tagMap.put( key, value );
        }
    }

    @Override
    public String toString()
    {
        String ret = "CompoundTag: \n";
        for( Map.Entry<String, NBTTag> entry : tagMap.entrySet() )
        {
           ret += "\t" + entry.getKey() + "\n";
           ret += "\t\t" + entry.getValue().toString() + "\n";
        }
        return ret;
    }
}
