/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.lang.constant.Constable;
import java.util.List;
import net.md_5.bungee.protocol.BadPacketException;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.FastDecoderException;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.Protocol;

public class MinecraftDecoder
extends MessageToMessageDecoder<ByteBuf> {
    private Protocol protocol;
    private final boolean server;
    private int protocolVersion;
    private boolean supportsForge = false;

    public MinecraftDecoder(Protocol protocol, boolean server, int protocolVersion) {
        this.protocol = protocol;
        this.server = server;
        this.protocolVersion = protocolVersion;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        Protocol.DirectionData prot = this.server ? this.protocol.TO_SERVER : this.protocol.TO_CLIENT;
        ByteBuf slice = in.copy();
        Constable packetTypeInfo = null;
        try {
            if (in.readableBytes() == 0) {
                return;
            }
            int packetId = DefinedPacket.readVarInt(in);
            packetTypeInfo = packetId;
            DefinedPacket packet = prot.createPacket(packetId, this.protocolVersion, this.supportsForge);
            if (packet != null) {
                packetTypeInfo = packet.getClass();
                packet.read(in, prot.getDirection(), this.protocolVersion);
                if (in.isReadable()) {
                    throw new BadPacketException("Did not read all bytes from packet " + packet.getClass() + " " + packetId + " Protocol " + (Object)((Object)this.protocol) + " Direction " + (Object)((Object)prot.getDirection()));
                }
            } else {
                in.skipBytes(in.readableBytes());
            }
            out.add(new PacketWrapper(packet, slice));
            slice = null;
        }
        catch (IndexOutOfBoundsException | BadPacketException e) {
            String packetTypeStr = packetTypeInfo instanceof Integer ? "id " + Integer.toHexString(packetTypeInfo) : (packetTypeInfo instanceof Class ? "class " + ((Class)packetTypeInfo).getSimpleName() : "unknown");
            throw new FastDecoderException("Error decoding packet " + packetTypeStr + " with contents:\n" + ByteBufUtil.prettyHexDump((ByteBuf)slice), e);
        }
        finally {
            if (slice != null) {
                slice.release();
            }
        }
    }

    public MinecraftDecoder(Protocol protocol, boolean server, int protocolVersion, boolean supportsForge) {
        this.protocol = protocol;
        this.server = server;
        this.protocolVersion = protocolVersion;
        this.supportsForge = supportsForge;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setProtocolVersion(int protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public void setSupportsForge(boolean supportsForge) {
        this.supportsForge = supportsForge;
    }
}

