/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.CorruptedFrameException;
import java.util.List;
import net.md_5.bungee.protocol.DefinedPacket;

public class Varint21FrameDecoder
extends ByteToMessageDecoder {
    private static boolean DIRECT_WARNING;
    private boolean allowEmptyPackets;

    public Varint21FrameDecoder(boolean allowEmptyPackets) {
        this.allowEmptyPackets = allowEmptyPackets;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        in.markReaderIndex();
        for (int i = 0; i < 3; ++i) {
            if (!in.isReadable()) {
                in.resetReaderIndex();
                return;
            }
            byte read = in.readByte();
            if (read < 0) continue;
            in.resetReaderIndex();
            int length = DefinedPacket.readVarInt(in);
            if (length == 0 && !this.allowEmptyPackets) {
                throw new CorruptedFrameException("Empty Packet!");
            }
            if (in.readableBytes() < length) {
                in.resetReaderIndex();
                return;
            }
            out.add(in.readRetainedSlice(length));
            return;
        }
        throw new CorruptedFrameException("length wider than 21-bit");
    }
}

