/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import io.netty.buffer.ByteBuf;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;

public class Commands
extends DefinedPacket {
    private static final int FLAG_TYPE = 3;
    private static final int FLAG_EXECUTABLE = 4;
    private static final int FLAG_REDIRECT = 8;
    private static final int FLAG_SUGGESTIONS = 16;
    private static final int NODE_ROOT = 0;
    private static final int NODE_LITERAL = 1;
    private static final int NODE_ARGUMENT = 2;
    private RootCommandNode root;

    @Override
    public void read(ByteBuf buf) {
        boolean mustCycle;
        int nodeCount = Commands.readVarInt(buf);
        NetworkNode[] nodes = new NetworkNode[nodeCount];
        ArrayDeque<NetworkNode> nodeQueue = new ArrayDeque<NetworkNode>(nodes.length);
        for (int i = 0; i < nodeCount; ++i) {
            NetworkNode node;
            LiteralArgumentBuilder argumentBuilder;
            byte flags = buf.readByte();
            int[] children = Commands.readVarIntArray(buf);
            int redirectNode = (flags & 8) != 0 ? Commands.readVarInt(buf) : 0;
            switch (flags & 3) {
                case 0: {
                    argumentBuilder = null;
                    break;
                }
                case 1: {
                    argumentBuilder = LiteralArgumentBuilder.literal((String)Commands.readString(buf));
                    break;
                }
                case 2: {
                    String name = Commands.readString(buf);
                    String parser = Commands.readString(buf);
                    argumentBuilder = RequiredArgumentBuilder.argument((String)name, (ArgumentType)ArgumentRegistry.read(parser, buf));
                    if ((flags & 0x10) == 0) break;
                    String suggster = Commands.readString(buf);
                    ((RequiredArgumentBuilder)argumentBuilder).suggests(SuggestionRegistry.getProvider(suggster));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled node type " + flags);
                }
            }
            nodes[i] = node = new NetworkNode((ArgumentBuilder)argumentBuilder, flags, redirectNode, children);
            nodeQueue.add(node);
        }
        do {
            if (nodeQueue.isEmpty()) {
                int rootIndex = Commands.readVarInt(buf);
                this.root = (RootCommandNode)nodes[rootIndex].command;
                return;
            }
            mustCycle = false;
            Iterator iter = nodeQueue.iterator();
            while (iter.hasNext()) {
                NetworkNode node = (NetworkNode)iter.next();
                if (!node.buildSelf(nodes)) continue;
                iter.remove();
                mustCycle = true;
            }
        } while (mustCycle);
        throw new IllegalStateException("Did not finish building root node");
    }

    @Override
    public void write(ByteBuf buf) {
        LinkedHashMap<CommandNode, Integer> indexMap = new LinkedHashMap<CommandNode, Integer>();
        ArrayDeque<Object> nodeQueue = new ArrayDeque<Object>();
        nodeQueue.add(this.root);
        while (!nodeQueue.isEmpty()) {
            CommandNode command = (CommandNode)nodeQueue.pollFirst();
            if (indexMap.containsKey(command)) continue;
            int currentIndex = indexMap.size();
            indexMap.put(command, currentIndex);
            nodeQueue.addAll(command.getChildren());
            if (command.getRedirect() == null) continue;
            nodeQueue.add(command.getRedirect());
        }
        Commands.writeVarInt(indexMap.size(), buf);
        int currentIndex = 0;
        for (Map.Entry entry : indexMap.entrySet()) {
            Preconditions.checkState(((Integer)entry.getValue() == currentIndex++ ? 1 : 0) != 0, (Object)"Iteration out of order!");
            CommandNode node = (CommandNode)entry.getKey();
            int flags = 0;
            if (node.getRedirect() != null) {
                flags = (byte)(flags | 8);
            }
            if (node.getCommand() != null) {
                flags = (byte)(flags | 4);
            }
            if (node instanceof RootCommandNode) {
                flags = (byte)(flags | 0);
            } else if (node instanceof LiteralCommandNode) {
                flags = (byte)(flags | 1);
            } else if (node instanceof ArgumentCommandNode) {
                flags = (byte)(flags | 2);
                if (((ArgumentCommandNode)node).getCustomSuggestions() != null) {
                    flags = (byte)(flags | 0x10);
                }
            } else {
                throw new IllegalArgumentException("Unhandled node type " + node);
            }
            buf.writeByte(flags);
            Commands.writeVarInt(node.getChildren().size(), buf);
            for (CommandNode child : node.getChildren()) {
                Commands.writeVarInt((Integer)indexMap.get(child), buf);
            }
            if (node.getRedirect() != null) {
                Commands.writeVarInt((Integer)indexMap.get(node.getRedirect()), buf);
            }
            if (node instanceof LiteralCommandNode) {
                Commands.writeString(((LiteralCommandNode)node).getLiteral(), buf);
                continue;
            }
            if (!(node instanceof ArgumentCommandNode)) continue;
            ArgumentCommandNode argumentNode = (ArgumentCommandNode)node;
            Commands.writeString(argumentNode.getName(), buf);
            ArgumentRegistry.write(argumentNode.getType(), buf);
            if (argumentNode.getCustomSuggestions() == null) continue;
            Commands.writeString(SuggestionRegistry.getKey((SuggestionProvider<SuggestionRegistry.DummyProvider>)argumentNode.getCustomSuggestions()), buf);
        }
        int rootIndex = (Integer)indexMap.get(this.root);
        Preconditions.checkState((rootIndex == 0 ? 1 : 0) != 0, (Object)"How did root not land up at index 0?!?");
        Commands.writeVarInt(rootIndex, buf);
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    private static byte binaryFlag(boolean first, boolean second) {
        byte ret = 0;
        if (first) {
            ret = (byte)(ret | 1);
        }
        if (second) {
            ret = (byte)(ret | 2);
        }
        return ret;
    }

    public RootCommandNode getRoot() {
        return this.root;
    }

    public void setRoot(RootCommandNode root) {
        this.root = root;
    }

    @Override
    public String toString() {
        return "Commands(root=" + this.getRoot() + ")";
    }

    public Commands() {
    }

    public Commands(RootCommandNode root) {
        this.root = root;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Commands)) {
            return false;
        }
        Commands other = (Commands)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RootCommandNode this$root = this.getRoot();
        RootCommandNode other$root = other.getRoot();
        return !(this$root == null ? other$root != null : !this$root.equals(other$root));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Commands;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RootCommandNode $root = this.getRoot();
        result = result * 59 + ($root == null ? 43 : $root.hashCode());
        return result;
    }

    public static class SuggestionRegistry {
        public static final SuggestionProvider ASK_SERVER = new DummyProvider("minecraft:ask_server");
        private static final Map<String, SuggestionProvider<DummyProvider>> PROVIDERS = new HashMap<String, SuggestionProvider<DummyProvider>>();

        private static void registerDummy(String name) {
            PROVIDERS.put(name, new DummyProvider(name));
        }

        private static SuggestionProvider<DummyProvider> getProvider(String key) {
            SuggestionProvider<DummyProvider> provider = PROVIDERS.get(key);
            Preconditions.checkArgument((provider != null ? 1 : 0) != 0, (Object)("Unknown completion provider " + key));
            return provider;
        }

        private static String getKey(SuggestionProvider<DummyProvider> provider) {
            Preconditions.checkArgument((boolean)(provider instanceof DummyProvider), (Object)("Non dummy provider " + provider));
            return ((DummyProvider)provider).key;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SuggestionRegistry)) {
                return false;
            }
            SuggestionRegistry other = (SuggestionRegistry)o;
            return other.canEqual(this);
        }

        protected boolean canEqual(Object other) {
            return other instanceof SuggestionRegistry;
        }

        public int hashCode() {
            int result = 1;
            return result;
        }

        public String toString() {
            return "Commands.SuggestionRegistry()";
        }

        static {
            PROVIDERS.put("minecraft:ask_server", (SuggestionProvider<DummyProvider>)ASK_SERVER);
            SuggestionRegistry.registerDummy("minecraft:all_recipes");
            SuggestionRegistry.registerDummy("minecraft:available_sounds");
            SuggestionRegistry.registerDummy("minecraft:summonable_entities");
        }

        private static final class DummyProvider
        implements SuggestionProvider<DummyProvider> {
            private final String key;

            public CompletableFuture<Suggestions> getSuggestions(CommandContext<DummyProvider> context, SuggestionsBuilder builder) throws CommandSyntaxException {
                return builder.buildFuture();
            }

            public DummyProvider(String key) {
                this.key = key;
            }

            public String getKey() {
                return this.key;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DummyProvider)) {
                    return false;
                }
                DummyProvider other = (DummyProvider)o;
                String this$key = this.getKey();
                String other$key = other.getKey();
                return !(this$key == null ? other$key != null : !this$key.equals(other$key));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $key = this.getKey();
                result = result * 59 + ($key == null ? 43 : $key.hashCode());
                return result;
            }

            public String toString() {
                return "Commands.SuggestionRegistry.DummyProvider(key=" + this.getKey() + ")";
            }
        }
    }

    private static class ArgumentRegistry {
        private static final Map<String, ArgumentSerializer> PROVIDERS = new HashMap<String, ArgumentSerializer>();
        private static final Map<Class<?>, ProperArgumentSerializer<?>> PROPER_PROVIDERS = new HashMap();
        private static final ArgumentSerializer<Void> VOID = new ArgumentSerializer<Void>(){

            @Override
            protected Void read(ByteBuf buf) {
                return null;
            }

            @Override
            protected void write(ByteBuf buf, Void t) {
            }
        };
        private static final ArgumentSerializer<Boolean> BOOLEAN = new ArgumentSerializer<Boolean>(){

            @Override
            protected Boolean read(ByteBuf buf) {
                return buf.readBoolean();
            }

            @Override
            protected void write(ByteBuf buf, Boolean t) {
                buf.writeBoolean(t.booleanValue());
            }
        };
        private static final ArgumentSerializer<Byte> BYTE = new ArgumentSerializer<Byte>(){

            @Override
            protected Byte read(ByteBuf buf) {
                return buf.readByte();
            }

            @Override
            protected void write(ByteBuf buf, Byte t) {
                buf.writeByte((int)t.byteValue());
            }
        };
        private static final ArgumentSerializer<FloatArgumentType> FLOAT = new ArgumentSerializer<FloatArgumentType>(){

            @Override
            protected FloatArgumentType read(ByteBuf buf) {
                byte flags = buf.readByte();
                float min = (flags & 1) != 0 ? buf.readFloat() : -3.4028235E38f;
                float max = (flags & 2) != 0 ? buf.readFloat() : -3.4028235E38f;
                return FloatArgumentType.floatArg((float)min, (float)max);
            }

            @Override
            protected void write(ByteBuf buf, FloatArgumentType t) {
                boolean hasMin = t.getMinimum() != -3.4028235E38f;
                boolean hasMax = t.getMaximum() != Float.MAX_VALUE;
                buf.writeByte((int)Commands.binaryFlag(hasMin, hasMax));
                if (hasMin) {
                    buf.writeFloat(t.getMinimum());
                }
                if (hasMax) {
                    buf.writeFloat(t.getMaximum());
                }
            }
        };
        private static final ArgumentSerializer<DoubleArgumentType> DOUBLE = new ArgumentSerializer<DoubleArgumentType>(){

            @Override
            protected DoubleArgumentType read(ByteBuf buf) {
                byte flags = buf.readByte();
                double min = (flags & 1) != 0 ? buf.readDouble() : -1.7976931348623157E308;
                double max = (flags & 2) != 0 ? buf.readDouble() : -1.7976931348623157E308;
                return DoubleArgumentType.doubleArg((double)min, (double)max);
            }

            @Override
            protected void write(ByteBuf buf, DoubleArgumentType t) {
                boolean hasMin = t.getMinimum() != -1.7976931348623157E308;
                boolean hasMax = t.getMaximum() != Double.MAX_VALUE;
                buf.writeByte((int)Commands.binaryFlag(hasMin, hasMax));
                if (hasMin) {
                    buf.writeDouble(t.getMinimum());
                }
                if (hasMax) {
                    buf.writeDouble(t.getMaximum());
                }
            }
        };
        private static final ArgumentSerializer<IntegerArgumentType> INTEGER = new ArgumentSerializer<IntegerArgumentType>(){

            @Override
            protected IntegerArgumentType read(ByteBuf buf) {
                byte flags = buf.readByte();
                int min = (flags & 1) != 0 ? buf.readInt() : Integer.MIN_VALUE;
                int max = (flags & 2) != 0 ? buf.readInt() : Integer.MAX_VALUE;
                return IntegerArgumentType.integer((int)min, (int)max);
            }

            @Override
            protected void write(ByteBuf buf, IntegerArgumentType t) {
                boolean hasMin = t.getMinimum() != Integer.MIN_VALUE;
                boolean hasMax = t.getMaximum() != Integer.MAX_VALUE;
                buf.writeByte((int)Commands.binaryFlag(hasMin, hasMax));
                if (hasMin) {
                    buf.writeInt(t.getMinimum());
                }
                if (hasMax) {
                    buf.writeInt(t.getMaximum());
                }
            }
        };
        private static final ProperArgumentSerializer<StringArgumentType> STRING = new ProperArgumentSerializer<StringArgumentType>(){

            @Override
            protected StringArgumentType read(ByteBuf buf) {
                int val = DefinedPacket.readVarInt(buf);
                switch (val) {
                    case 0: {
                        return StringArgumentType.word();
                    }
                    case 1: {
                        return StringArgumentType.string();
                    }
                    case 2: {
                        return StringArgumentType.greedyString();
                    }
                }
                throw new IllegalArgumentException("Unknown string type " + val);
            }

            @Override
            protected void write(ByteBuf buf, StringArgumentType t) {
                DefinedPacket.writeVarInt(t.getType().ordinal(), buf);
            }

            @Override
            protected String getKey() {
                return "brigadier:string";
            }
        };

        private static ArgumentType<?> read(String key, ByteBuf buf) {
            ArgumentSerializer reader = PROVIDERS.get(key);
            Preconditions.checkArgument((reader != null ? 1 : 0) != 0, (Object)("No provider for argument " + key));
            Object val = reader.read(buf);
            return val != null && PROPER_PROVIDERS.containsKey(val.getClass()) ? (ArgumentType)val : new DummyType(key, reader, val);
        }

        private static void write(ArgumentType<?> arg, ByteBuf buf) {
            ProperArgumentSerializer<?> proper = PROPER_PROVIDERS.get(arg.getClass());
            if (proper != null) {
                DefinedPacket.writeString(proper.getKey(), buf);
                proper.write(buf, arg);
            } else {
                Preconditions.checkArgument((boolean)(arg instanceof DummyType), (Object)("Non dummy arg " + arg.getClass()));
                DummyType dummy = (DummyType)arg;
                DefinedPacket.writeString(dummy.key, buf);
                dummy.serializer.write(buf, dummy.value);
            }
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArgumentRegistry)) {
                return false;
            }
            ArgumentRegistry other = (ArgumentRegistry)o;
            return other.canEqual(this);
        }

        protected boolean canEqual(Object other) {
            return other instanceof ArgumentRegistry;
        }

        public int hashCode() {
            int result = 1;
            return result;
        }

        public String toString() {
            return "Commands.ArgumentRegistry()";
        }

        static {
            PROVIDERS.put("brigadier:bool", VOID);
            PROVIDERS.put("brigadier:float", FLOAT);
            PROVIDERS.put("brigadier:double", DOUBLE);
            PROVIDERS.put("brigadier:integer", INTEGER);
            PROVIDERS.put("brigadier:string", STRING);
            PROPER_PROVIDERS.put(StringArgumentType.class, STRING);
            PROVIDERS.put("minecraft:entity", BYTE);
            PROVIDERS.put("minecraft:game_profile", VOID);
            PROVIDERS.put("minecraft:block_pos", VOID);
            PROVIDERS.put("minecraft:column_pos", VOID);
            PROVIDERS.put("minecraft:vec3", VOID);
            PROVIDERS.put("minecraft:vec2", VOID);
            PROVIDERS.put("minecraft:block_state", VOID);
            PROVIDERS.put("minecraft:block_predicate", VOID);
            PROVIDERS.put("minecraft:item_stack", VOID);
            PROVIDERS.put("minecraft:item_predicate", VOID);
            PROVIDERS.put("minecraft:color", VOID);
            PROVIDERS.put("minecraft:component", VOID);
            PROVIDERS.put("minecraft:message", VOID);
            PROVIDERS.put("minecraft:nbt_compound_tag", VOID);
            PROVIDERS.put("minecraft:nbt_tag", VOID);
            PROVIDERS.put("minecraft:nbt", VOID);
            PROVIDERS.put("minecraft:nbt_path", VOID);
            PROVIDERS.put("minecraft:objective", VOID);
            PROVIDERS.put("minecraft:objective_criteria", VOID);
            PROVIDERS.put("minecraft:operation", VOID);
            PROVIDERS.put("minecraft:particle", VOID);
            PROVIDERS.put("minecraft:rotation", VOID);
            PROVIDERS.put("minecraft:scoreboard_slot", VOID);
            PROVIDERS.put("minecraft:score_holder", BYTE);
            PROVIDERS.put("minecraft:swizzle", VOID);
            PROVIDERS.put("minecraft:team", VOID);
            PROVIDERS.put("minecraft:item_slot", VOID);
            PROVIDERS.put("minecraft:resource_location", VOID);
            PROVIDERS.put("minecraft:mob_effect", VOID);
            PROVIDERS.put("minecraft:function", VOID);
            PROVIDERS.put("minecraft:entity_anchor", VOID);
            PROVIDERS.put("minecraft:int_range", VOID);
            PROVIDERS.put("minecraft:float_range", VOID);
            PROVIDERS.put("minecraft:item_enchantment", VOID);
            PROVIDERS.put("minecraft:entity_summon", VOID);
            PROVIDERS.put("minecraft:dimension", VOID);
            PROVIDERS.put("minecraft:time", VOID);
        }

        private static abstract class ProperArgumentSerializer<T>
        extends ArgumentSerializer<T> {
            private ProperArgumentSerializer() {
            }

            protected abstract String getKey();
        }

        private static abstract class ArgumentSerializer<T> {
            private ArgumentSerializer() {
            }

            protected abstract T read(ByteBuf var1);

            protected abstract void write(ByteBuf var1, T var2);
        }

        private static class DummyType<T>
        implements ArgumentType<T> {
            private final String key;
            private final ArgumentSerializer<T> serializer;
            private final T value;

            public T parse(StringReader reader) throws CommandSyntaxException {
                throw new UnsupportedOperationException("Not supported.");
            }

            public DummyType(String key, ArgumentSerializer<T> serializer, T value) {
                this.key = key;
                this.serializer = serializer;
                this.value = value;
            }

            public String getKey() {
                return this.key;
            }

            public ArgumentSerializer<T> getSerializer() {
                return this.serializer;
            }

            public T getValue() {
                return this.value;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DummyType)) {
                    return false;
                }
                DummyType other = (DummyType)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$key = this.getKey();
                String other$key = other.getKey();
                if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                    return false;
                }
                ArgumentSerializer<T> this$serializer = this.getSerializer();
                ArgumentSerializer<T> other$serializer = other.getSerializer();
                if (this$serializer == null ? other$serializer != null : !this$serializer.equals(other$serializer)) {
                    return false;
                }
                T this$value = this.getValue();
                T other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            protected boolean canEqual(Object other) {
                return other instanceof DummyType;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $key = this.getKey();
                result = result * 59 + ($key == null ? 43 : $key.hashCode());
                ArgumentSerializer<T> $serializer = this.getSerializer();
                result = result * 59 + ($serializer == null ? 43 : $serializer.hashCode());
                T $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }

            public String toString() {
                return "Commands.ArgumentRegistry.DummyType(key=" + this.getKey() + ", serializer=" + this.getSerializer() + ", value=" + this.getValue() + ")";
            }
        }
    }

    private static class NetworkNode {
        private final ArgumentBuilder argumentBuilder;
        private final byte flags;
        private final int redirectNode;
        private final int[] children;
        private CommandNode command;

        private boolean buildSelf(NetworkNode[] otherNodes) {
            if (this.command == null) {
                if (this.argumentBuilder == null) {
                    this.command = new RootCommandNode();
                } else {
                    if ((this.flags & 8) != 0) {
                        if (otherNodes[this.redirectNode].command == null) {
                            return false;
                        }
                        this.argumentBuilder.redirect(otherNodes[this.redirectNode].command);
                    }
                    if ((this.flags & 4) != 0) {
                        this.argumentBuilder.executes(new Command(){

                            public int run(CommandContext context) throws CommandSyntaxException {
                                return 0;
                            }
                        });
                    }
                    this.command = this.argumentBuilder.build();
                }
            }
            for (int childIndex : this.children) {
                if (otherNodes[childIndex].command != null) continue;
                return false;
            }
            for (int childIndex : this.children) {
                CommandNode child = otherNodes[childIndex].command;
                Preconditions.checkArgument((!(child instanceof RootCommandNode) ? 1 : 0) != 0, (Object)"Cannot have RootCommandNode as child");
                this.command.addChild(child);
            }
            return true;
        }

        public NetworkNode(ArgumentBuilder argumentBuilder, byte flags, int redirectNode, int[] children) {
            this.argumentBuilder = argumentBuilder;
            this.flags = flags;
            this.redirectNode = redirectNode;
            this.children = children;
        }

        public ArgumentBuilder getArgumentBuilder() {
            return this.argumentBuilder;
        }

        public byte getFlags() {
            return this.flags;
        }

        public int getRedirectNode() {
            return this.redirectNode;
        }

        public int[] getChildren() {
            return this.children;
        }

        public CommandNode getCommand() {
            return this.command;
        }

        public void setCommand(CommandNode command) {
            this.command = command;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NetworkNode)) {
                return false;
            }
            NetworkNode other = (NetworkNode)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ArgumentBuilder this$argumentBuilder = this.getArgumentBuilder();
            ArgumentBuilder other$argumentBuilder = other.getArgumentBuilder();
            if (this$argumentBuilder == null ? other$argumentBuilder != null : !this$argumentBuilder.equals(other$argumentBuilder)) {
                return false;
            }
            if (this.getFlags() != other.getFlags()) {
                return false;
            }
            if (this.getRedirectNode() != other.getRedirectNode()) {
                return false;
            }
            if (!Arrays.equals(this.getChildren(), other.getChildren())) {
                return false;
            }
            CommandNode this$command = this.getCommand();
            CommandNode other$command = other.getCommand();
            return !(this$command == null ? other$command != null : !this$command.equals(other$command));
        }

        protected boolean canEqual(Object other) {
            return other instanceof NetworkNode;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ArgumentBuilder $argumentBuilder = this.getArgumentBuilder();
            result = result * 59 + ($argumentBuilder == null ? 43 : $argumentBuilder.hashCode());
            result = result * 59 + this.getFlags();
            result = result * 59 + this.getRedirectNode();
            result = result * 59 + Arrays.hashCode(this.getChildren());
            CommandNode $command = this.getCommand();
            result = result * 59 + ($command == null ? 43 : $command.hashCode());
            return result;
        }

        public String toString() {
            return "Commands.NetworkNode(argumentBuilder=" + this.getArgumentBuilder() + ", flags=" + this.getFlags() + ", redirectNode=" + this.getRedirectNode() + ", children=" + Arrays.toString(this.getChildren()) + ", command=" + this.getCommand() + ")";
        }
    }
}

