/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.event;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.md_5.bungee.event.EventExceptionHandler;
import net.md_5.bungee.event.EventHandler;
import net.md_5.bungee.event.EventHandlerMethod;

public class EventBus {
    private final Map<Class<?>, Map<Byte, Map<Object, Method[]>>> byListenerAndPriority = new HashMap();
    private final Map<Class<?>, EventHandlerMethod[]> byEventBaked = new ConcurrentHashMap();
    private final Lock lock = new ReentrantLock();
    private final Logger logger;

    public EventBus() {
        this(null);
    }

    public EventBus(Logger logger) {
        this.logger = logger == null ? Logger.getLogger("global") : logger;
    }

    public <T> void post(T event, EventExceptionHandler<T> exceptionHandler) {
        EventHandlerMethod[] handlers = this.byEventBaked.get(event.getClass());
        if (handlers != null) {
            for (EventHandlerMethod method : handlers) {
                long start;
                block6: {
                    start = System.nanoTime();
                    try {
                        method.invoke(event);
                    }
                    catch (IllegalAccessException ex) {
                        throw new Error("Method became inaccessible: " + event, ex);
                    }
                    catch (IllegalArgumentException ex) {
                        throw new Error("Method rejected target/argument: " + event, ex);
                    }
                    catch (InvocationTargetException ex) {
                        String msg = MessageFormat.format("Error dispatching event {0} to listener {1}", event, method.getListener());
                        this.logger.log(Level.WARNING, msg, ex.getCause());
                        if (exceptionHandler == null) break block6;
                        exceptionHandler.handleEventException(msg, event, method, ex);
                    }
                }
                long elapsed = System.nanoTime() - start;
                if (elapsed <= 50000000L) continue;
                this.logger.log(Level.WARNING, "Plugin listener {0} took {1}ms to process event {2}!", new Object[]{method.getListener().getClass().getName(), elapsed / 1000000L, event});
            }
        }
    }

    private Map<Class<?>, Map<Byte, Set<Method>>> findHandlers(Object listener) {
        HashMap handler = new HashMap();
        ImmutableSet methods = ImmutableSet.builder().add((Object[])listener.getClass().getMethods()).add((Object[])listener.getClass().getDeclaredMethods()).build();
        for (Method m : methods) {
            EventHandler annotation = m.getAnnotation(EventHandler.class);
            if (annotation == null) continue;
            Class<?>[] params = m.getParameterTypes();
            if (params.length != 1) {
                this.logger.log(Level.INFO, "Method {0} in class {1} annotated with {2} does not have single argument", new Object[]{m, listener.getClass(), annotation});
                continue;
            }
            Map prioritiesMap = handler.computeIfAbsent(params[0], k -> new HashMap());
            Set priority = prioritiesMap.computeIfAbsent(annotation.priority(), k -> new HashSet());
            priority.add(m);
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Object listener) {
        Map<Class<?>, Map<Byte, Set<Method>>> handler = this.findHandlers(listener);
        this.lock.lock();
        try {
            for (Map.Entry<Class<?>, Map<Byte, Set<Method>>> e : handler.entrySet()) {
                Map prioritiesMap = this.byListenerAndPriority.computeIfAbsent(e.getKey(), k -> new HashMap());
                for (Map.Entry<Byte, Set<Method>> entry : e.getValue().entrySet()) {
                    Map currentPriorityMap = prioritiesMap.computeIfAbsent(entry.getKey(), k -> new HashMap());
                    currentPriorityMap.put(listener, entry.getValue().toArray(new Method[0]));
                }
                this.bakeHandlers(e.getKey());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Object listener) {
        Map<Class<?>, Map<Byte, Set<Method>>> handler = this.findHandlers(listener);
        this.lock.lock();
        try {
            for (Map.Entry<Class<?>, Map<Byte, Set<Method>>> e : handler.entrySet()) {
                Map<Byte, Map<Object, Method[]>> prioritiesMap = this.byListenerAndPriority.get(e.getKey());
                if (prioritiesMap != null) {
                    for (Byte priority : e.getValue().keySet()) {
                        Map<Object, Method[]> currentPriority = prioritiesMap.get(priority);
                        if (currentPriority == null) continue;
                        currentPriority.remove(listener);
                        if (!currentPriority.isEmpty()) continue;
                        prioritiesMap.remove(priority);
                    }
                    if (prioritiesMap.isEmpty()) {
                        this.byListenerAndPriority.remove(e.getKey());
                    }
                }
                this.bakeHandlers(e.getKey());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void bakeHandlers(Class<?> eventClass) {
        Map<Byte, Map<Object, Method[]>> handlersByPriority = this.byListenerAndPriority.get(eventClass);
        if (handlersByPriority != null) {
            byte by;
            ArrayList<EventHandlerMethod> handlersList = new ArrayList<EventHandlerMethod>(handlersByPriority.size() * 2);
            byte value = -128;
            do {
                Map<Object, Method[]> handlersByListener;
                if ((handlersByListener = handlersByPriority.get(value)) != null) {
                    for (Map.Entry<Object, Method[]> listenerHandlers : handlersByListener.entrySet()) {
                        for (Method method : listenerHandlers.getValue()) {
                            EventHandlerMethod ehm = new EventHandlerMethod(listenerHandlers.getKey(), method);
                            handlersList.add(ehm);
                        }
                    }
                }
                by = value;
                value = (byte)(value + 1);
            } while (by < 127);
            this.byEventBaked.put(eventClass, handlersList.toArray(new EventHandlerMethod[0]));
        } else {
            this.byEventBaked.remove(eventClass);
        }
    }
}

